/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin;

import com.shanebeestudios.hg.api.commandapi.CommandAPI;
import com.shanebeestudios.hg.api.commandapi.CommandAPIBukkitConfig;
import com.shanebeestudios.hg.api.commandapi.exceptions.UnsupportedVersionException;
import com.shanebeestudios.hg.api.data.Leaderboard;
import com.shanebeestudios.hg.api.metrics.bukkit.Metrics;
import com.shanebeestudios.hg.api.metrics.charts.SimplePie;
import com.shanebeestudios.hg.api.util.NBTApi;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.commands.MainCommand;
import com.shanebeestudios.hg.plugin.configs.ArenaConfig;
import com.shanebeestudios.hg.plugin.configs.Config;
import com.shanebeestudios.hg.plugin.configs.Language;
import com.shanebeestudios.hg.plugin.listeners.GameBlockListener;
import com.shanebeestudios.hg.plugin.listeners.GameChestListener;
import com.shanebeestudios.hg.plugin.listeners.GameCommandListener;
import com.shanebeestudios.hg.plugin.listeners.GameCompassListener;
import com.shanebeestudios.hg.plugin.listeners.GameDamageListenerBase;
import com.shanebeestudios.hg.plugin.listeners.GameEntityListener;
import com.shanebeestudios.hg.plugin.listeners.GameKitGuiListener;
import com.shanebeestudios.hg.plugin.listeners.GameLobbyListener;
import com.shanebeestudios.hg.plugin.listeners.GamePlayerListener;
import com.shanebeestudios.hg.plugin.listeners.GameTrackingStickListener;
import com.shanebeestudios.hg.plugin.listeners.SessionWandListener;
import com.shanebeestudios.hg.plugin.managers.GameManager;
import com.shanebeestudios.hg.plugin.managers.ItemManager;
import com.shanebeestudios.hg.plugin.managers.KillManager;
import com.shanebeestudios.hg.plugin.managers.KitManager;
import com.shanebeestudios.hg.plugin.managers.MobManager;
import com.shanebeestudios.hg.plugin.managers.Placeholders;
import com.shanebeestudios.hg.plugin.managers.PlayerManager;
import com.shanebeestudios.hg.plugin.managers.SessionManager;
import io.lumine.mythic.api.MythicProvider;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class HungerGames
extends JavaPlugin {
    private static HungerGames PLUGIN_INSTANCE;
    private Leaderboard leaderboard;
    private Metrics metrics;
    private Config config;
    private Language lang;
    private ArenaConfig arenaConfig;
    private GameManager gameManager;
    private PlayerManager playerManager;
    private KillManager killManager;
    private ItemManager itemManager;
    private KitManager kitManager;
    private SessionManager sessionManager;
    private MobManager mobManager;
    private io.lumine.mythic.api.mobs.MobManager mythicMobManager;

    public void onLoad() {
        try {
            CommandAPI.onLoad(((CommandAPIBukkitConfig)((CommandAPIBukkitConfig)new CommandAPIBukkitConfig(this).setNamespace("hungergames").verboseOutput(false)).silentLogs(true)).skipReloadDatapacks(true));
        }
        catch (UnsupportedVersionException ignore) {
            Util.log("CommandAPI does not support this version of Minecraft, will update soon.", new Object[0]);
        }
    }

    public void onEnable() {
        if (!Util.isRunningMinecraft(1, 21, 4)) {
            Util.warning("HungerGames does not support your server version!", new Object[0]);
            Util.warning("Only versions 1.21.4+ are supported", new Object[0]);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        NBTApi.initializeNBTApi();
        this.loadPlugin(true);
    }

    public void loadPlugin(boolean load) {
        long start = System.currentTimeMillis();
        PLUGIN_INSTANCE = this;
        this.config = new Config(this);
        if (Bukkit.getPluginManager().getPlugin("MythicMobs") != null) {
            this.mythicMobManager = MythicProvider.get().getMobManager();
            Util.log("<grey>MythicMobs found, MythicMobs hook <green>enabled", new Object[0]);
        } else {
            Util.log("<grey>MythicMobs not found, MythicMobs hook <red>disabled", new Object[0]);
        }
        this.lang = new Language(this);
        this.itemManager = new ItemManager(this);
        this.kitManager = new KitManager(this);
        this.sessionManager = new SessionManager();
        this.mobManager = new MobManager(this);
        this.playerManager = new PlayerManager();
        this.gameManager = new GameManager(this);
        this.arenaConfig = new ArenaConfig(this);
        this.leaderboard = new Leaderboard(this);
        this.killManager = new KillManager(this);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new Placeholders(this).register();
            Util.log("<grey>PAPI found, Placeholders have been <green>enabled", new Object[0]);
        } else {
            Util.log("<grey>PAPI not found, Placeholders have been <red>disabled", new Object[0]);
        }
        this.loadCommands();
        this.loadListeners();
        if (this.getDescription().getVersion().contains("beta")) {
            Util.warning("YOU ARE RUNNING A BETA VERSION, please use with caution", new Object[0]);
            Util.warning("Report any issues to: <aqua>https://github.com/ShaneBeeStudios/HungerGames/issues", new Object[0]);
        }
        this.setupMetrics();
        Util.log("HungerGames has been <green>enabled<grey> in <aqua>%.2f seconds<grey>!", Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f));
    }

    public void reloadPlugin() {
        this.unloadPlugin(true);
    }

    private void unloadPlugin(boolean reload) {
        this.gameManager.stopAllGames();
        PLUGIN_INSTANCE = null;
        this.config = null;
        this.metrics = null;
        this.mobManager = null;
        this.mythicMobManager = null;
        this.lang = null;
        this.itemManager = null;
        this.kitManager = null;
        this.playerManager = null;
        this.arenaConfig = null;
        this.killManager = null;
        this.gameManager = null;
        this.leaderboard = null;
        HandlerList.unregisterAll((Plugin)this);
        if (reload) {
            this.loadPlugin(false);
        }
    }

    public void onDisable() {
        this.unloadPlugin(false);
        Util.log("HungerGames has been disabled!", new Object[0]);
    }

    private void setupMetrics() {
        this.metrics = new Metrics((Plugin)this, 25144);
        this.metrics.addCustomChart(new SimplePie("config-worldborder-enabled", () -> "" + Config.WORLD_BORDER_ENABLED));
        this.metrics.addCustomChart(new SimplePie("config-chestdrop-enabled", () -> "" + Config.CHESTS_CHEST_DROP_ENABLED));
        this.metrics.addCustomChart(new SimplePie("arenas-count", () -> "" + this.gameManager.getGames().size()));
    }

    private void loadListeners() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        pluginManager.registerEvents((Listener)new GameBlockListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new GameChestListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new GameCommandListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new GameCompassListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new GameDamageListenerBase(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new GameEntityListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new GameKitGuiListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new GameLobbyListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new GamePlayerListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new GameTrackingStickListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new SessionWandListener(this), (Plugin)this);
    }

    private void loadCommands() {
        if (CommandAPI.isLoaded()) {
            CommandAPI.onEnable();
            new MainCommand(this);
        }
    }

    public static HungerGames getPlugin() {
        return PLUGIN_INSTANCE;
    }

    public KillManager getKillManager() {
        return this.killManager;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public KitManager getKitManager() {
        return this.kitManager;
    }

    public GameManager getGameManager() {
        return this.gameManager;
    }

    public PlayerManager getPlayerManager() {
        return this.playerManager;
    }

    public ArenaConfig getArenaConfig() {
        return this.arenaConfig;
    }

    public Leaderboard getLeaderboard() {
        return this.leaderboard;
    }

    public Language getLang() {
        return this.lang;
    }

    public Config getHGConfig() {
        return this.config;
    }

    public MobManager getMobManager() {
        return this.mobManager;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public io.lumine.mythic.api.mobs.MobManager getMythicMobManager() {
        return this.mythicMobManager;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }
}

