/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.commands;

import com.shanebeestudios.hg.api.commandapi.AbstractArgumentTree;
import com.shanebeestudios.hg.api.commandapi.arguments.Argument;
import com.shanebeestudios.hg.api.commandapi.arguments.IntegerArgument;
import com.shanebeestudios.hg.api.commandapi.arguments.LiteralArgument;
import com.shanebeestudios.hg.api.commandapi.arguments.StringArgument;
import com.shanebeestudios.hg.api.commandapi.executors.CommandArguments;
import com.shanebeestudios.hg.api.data.PlayerSession;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.commands.SubCommand;
import com.shanebeestudios.hg.plugin.managers.SessionManager;
import com.shanebeestudios.hg.plugin.permission.Permissions;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CreateCommand
extends SubCommand {
    private final SessionManager sessionManager;

    public CreateCommand(HungerGames plugin) {
        super(plugin);
        this.sessionManager = plugin.getSessionManager();
    }

    @Override
    protected Argument<?> register() {
        return (Argument)((Argument)LiteralArgument.literal("create").withPermission(Permissions.COMMAND_CREATE.permission())).then(new StringArgument("name").then(new IntegerArgument("min-players", 2).then(new IntegerArgument("max-players").then(new IntegerArgument("time").then((AbstractArgumentTree)((Argument)new IntegerArgument("cost").setOptional(true)).executesPlayer(info -> {
            CommandArguments args = info.args();
            Player player = (Player)info.sender();
            UUID uuid = player.getUniqueId();
            String name = args.getByClass("name", String.class);
            Integer minPlayers = args.getByClass("min-players", Integer.class);
            Integer maxPlayers = args.getByClass("max-players", Integer.class);
            Integer time = args.getByClass("time", Integer.class);
            Integer cost = args.getByClassOrDefault("cost", Integer.class, Integer.valueOf(0));
            if (name == null || minPlayers == null || maxPlayers == null || time == null) {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_create_error_arguments, new Object[0]);
                return;
            }
            if (time % 30 != 0) {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_create_divisible_1, new Object[0]);
                Util.sendMessage((CommandSender)player, this.lang.command_create_divisible_2, new Object[0]);
                return;
            }
            if (minPlayers > maxPlayers) {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_create_minmax, new Object[0]);
                return;
            }
            Game game = this.plugin.getGameManager().getGame(name);
            if (game != null) {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_create_error_already_exists, new Object[0]);
                return;
            }
            if (this.sessionManager.hasPlayerSession(player)) {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_create_error_session_exists, new Object[0]);
            } else {
                PlayerSession playerSession = this.sessionManager.createPlayerSession(player, name, time, minPlayers, maxPlayers, cost);
                playerSession.start(player);
            }
        }))))));
    }
}

