/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.commands;

import com.shanebeestudios.hg.api.command.CustomArg;
import com.shanebeestudios.hg.api.commandapi.AbstractArgumentTree;
import com.shanebeestudios.hg.api.commandapi.arguments.Argument;
import com.shanebeestudios.hg.api.commandapi.arguments.LiteralArgument;
import com.shanebeestudios.hg.api.commandapi.executors.ExecutorType;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameArenaData;
import com.shanebeestudios.hg.api.game.GamePlayerData;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.commands.SubCommand;
import com.shanebeestudios.hg.plugin.permission.Permissions;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DeleteArenaCommand
extends SubCommand {
    public DeleteArenaCommand(HungerGames plugin) {
        super(plugin);
    }

    @Override
    protected Argument<?> register() {
        return (Argument)((Argument)LiteralArgument.literal("delete-arena").withPermission(Permissions.COMMAND_DELETE.permission())).then((AbstractArgumentTree)CustomArg.GAME.get("game").executes(info -> {
            CommandSender sender = (CommandSender)info.sender();
            Game game = CustomArg.getGame(info);
            GamePlayerData gamePlayerData = game.getGamePlayerData();
            GameArenaData gameArenaData = game.getGameArenaData();
            String name = gameArenaData.getName();
            try {
                Util.sendPrefixedMessage(sender, this.lang.command_delete_attempt.replace("<arena>", name), new Object[0]);
                switch (gameArenaData.getStatus()) {
                    case WAITING: 
                    case COUNTDOWN: 
                    case FREE_ROAM: 
                    case RUNNING: {
                        Util.sendMessage(sender, this.lang.command_delete_stopping, new Object[0]);
                        game.getGameBlockData().forceRollback();
                        game.stop(false);
                        break;
                    }
                    case ROLLBACK: {
                        Util.sendMessage(sender, this.lang.command_delete_rollback, new Object[0]);
                        return;
                    }
                }
                if (!gamePlayerData.getPlayers().isEmpty()) {
                    Util.sendMessage(sender, this.lang.command_delete_kicking, new Object[0]);
                    for (Player player : gamePlayerData.getPlayers()) {
                        gamePlayerData.leaveGame(player, false);
                    }
                }
                this.gameManager.deleteGame(game);
                Util.sendMessage(sender, this.lang.command_delete_deleted.replace("<arena>", name), new Object[0]);
            }
            catch (Exception e) {
                Util.sendMessage(sender, this.lang.command_delete_failed, new Object[0]);
                Util.sendMessage(sender, "Error Message: <red>" + e.getMessage(), new Object[0]);
            }
        }, new ExecutorType[0]));
    }
}

