/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.commands;

import com.shanebeestudios.hg.api.command.CustomArg;
import com.shanebeestudios.hg.api.commandapi.AbstractArgumentTree;
import com.shanebeestudios.hg.api.commandapi.CommandAPI;
import com.shanebeestudios.hg.api.commandapi.arguments.Argument;
import com.shanebeestudios.hg.api.commandapi.arguments.IntegerArgument;
import com.shanebeestudios.hg.api.commandapi.arguments.LiteralArgument;
import com.shanebeestudios.hg.api.commandapi.arguments.Location2DArgument;
import com.shanebeestudios.hg.api.commandapi.arguments.LocationArgument;
import com.shanebeestudios.hg.api.commandapi.arguments.LocationType;
import com.shanebeestudios.hg.api.commandapi.executors.ExecutorType;
import com.shanebeestudios.hg.api.commandapi.wrappers.Location2D;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameArenaData;
import com.shanebeestudios.hg.api.game.GameBorderData;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.commands.SubCommand;
import com.shanebeestudios.hg.plugin.permission.Permissions;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EditCommand
extends SubCommand {
    public EditCommand(HungerGames plugin) {
        super(plugin);
    }

    @Override
    protected Argument<?> register() {
        return (Argument)((Argument)LiteralArgument.literal("edit").withPermission(Permissions.COMMAND_EDIT.permission())).then(((Argument)((Argument)((Argument)((Argument)CustomArg.GAME.get("game").then(this.chestRefillRepeat())).then(this.chestRefillTime())).then(this.border())).then(this.info())).then(this.locations()));
    }

    private Argument<?> border() {
        return (Argument)((Argument)((Argument)((Argument)LiteralArgument.literal("border").then(LiteralArgument.literal("final_size").then((AbstractArgumentTree)new IntegerArgument("final_size", 5).executes(info -> {
            Game game = CustomArg.getGame(info);
            int finalSize = info.args().getByClass("final_size", Integer.class);
            GameBorderData gameBorderData = game.getGameBorderData();
            gameBorderData.setFinalBorderSize(finalSize);
            Util.sendPrefixedMessage((CommandSender)info.sender(), "Border final size set to %s", finalSize);
            this.saveGame(game);
        }, new ExecutorType[0])))).then(LiteralArgument.literal("countdown_start").then((AbstractArgumentTree)new IntegerArgument("countdown_start", 5).executes(info -> {
            Game game = CustomArg.getGame(info);
            int countdownStart = info.args().getByClass("countdown_start", Integer.class);
            GameBorderData gameBorderData = game.getGameBorderData();
            gameBorderData.setBorderCountdownStart(countdownStart);
            Util.sendPrefixedMessage((CommandSender)info.sender(), "Border countdown start set to %s", countdownStart);
            this.saveGame(game);
        }, new ExecutorType[0])))).then(LiteralArgument.literal("countdown_end").then((AbstractArgumentTree)new IntegerArgument("countdown_end", 5).executes(info -> {
            Game game = CustomArg.getGame(info);
            int countdownEnd = info.args().getByClass("countdown_end", Integer.class);
            GameBorderData gameBorderData = game.getGameBorderData();
            gameBorderData.setBorderCountdownEnd(countdownEnd);
            Util.sendPrefixedMessage((CommandSender)info.sender(), "Border countdown end set to %s", countdownEnd);
            this.saveGame(game);
        }, new ExecutorType[0])))).then(LiteralArgument.literal("center_location").then((AbstractArgumentTree)new Location2DArgument("center_location", LocationType.BLOCK_POSITION).executes(info -> {
            Game game = CustomArg.getGame(info);
            Location2D centerLocation = info.args().getByClass("center_location", Location2D.class);
            GameBorderData gameBorderData = game.getGameBorderData();
            gameBorderData.setCenterLocation(this.convert(centerLocation));
            Util.sendPrefixedMessage((CommandSender)info.sender(), "Border center location set to %s", new Object[]{centerLocation});
            this.saveGame(game);
        }, new ExecutorType[0])));
    }

    private Argument<?> chestRefillTime() {
        return (Argument)LiteralArgument.literal("chest-refill-time").then((AbstractArgumentTree)new IntegerArgument("time", 30).executes(info -> {
            Game game = CustomArg.getGame(info);
            CommandSender sender = (CommandSender)info.sender();
            String name = game.getGameArenaData().getName();
            int time = info.args().getByClass("time", Integer.class);
            if (time % 30 != 0) {
                Util.sendPrefixedMessage(sender, "<yellow><time> <red>must be in increments of 30", new Object[0]);
                return;
            }
            game.getGameArenaData().setChestRefillTime(time);
            this.saveGame(game);
            Util.sendPrefixedMessage(sender, this.lang.command_edit_chest_refill_time_set.replace("<arena>", name).replace("<sec>", String.valueOf(time)), new Object[0]);
        }, new ExecutorType[0]));
    }

    private Argument<?> chestRefillRepeat() {
        return (Argument)LiteralArgument.literal("chest-refill-repeat").then((AbstractArgumentTree)new IntegerArgument("time", 30).executes(info -> {
            Game game = CustomArg.getGame(info);
            CommandSender sender = (CommandSender)info.sender();
            String name = game.getGameArenaData().getName();
            int time = info.args().getByClass("time", Integer.class);
            if (time % 30 != 0) {
                Util.sendPrefixedMessage(sender, "<yellow><time> <red>must be in increments of 30", new Object[0]);
                return;
            }
            game.getGameArenaData().setChestRefillRepeat(time);
            this.saveGame(game);
            Util.sendPrefixedMessage(sender, this.lang.command_edit_chest_refill_repeat_set.replace("<arena>", name).replace("<sec>", String.valueOf(time)), new Object[0]);
        }, new ExecutorType[0]));
    }

    private Argument<?> info() {
        return (Argument)((Argument)((Argument)((Argument)((Argument)LiteralArgument.literal("info").then(LiteralArgument.literal("free_roam_time").then((AbstractArgumentTree)new IntegerArgument("seconds", -1).executes(info -> {
            Game game = CustomArg.getGame(info);
            int freeRoamTime = info.args().getByClass("seconds", Integer.class);
            game.getGameArenaData().setFreeRoamTime(freeRoamTime);
            Util.sendPrefixedMessage((CommandSender)info.sender(), "Free roam time set to %s", freeRoamTime);
            this.saveGame(game);
        }, new ExecutorType[0])))).then(LiteralArgument.literal("cost").then((AbstractArgumentTree)new IntegerArgument("dollars", 0).executes(info -> {
            Game game = CustomArg.getGame(info);
            int cost = info.args().getByClass("dollars", Integer.class);
            game.getGameArenaData().setCost(cost);
            Util.sendPrefixedMessage((CommandSender)info.sender(), "Cost set to %s", cost);
            this.saveGame(game);
        }, new ExecutorType[0])))).then(LiteralArgument.literal("timer").then((AbstractArgumentTree)new IntegerArgument("seconds", 30).executes(info -> {
            Game game = CustomArg.getGame(info);
            int timerSeconds = info.args().getByClass("seconds", Integer.class);
            game.getGameArenaData().setTimer(timerSeconds);
            Util.sendPrefixedMessage((CommandSender)info.sender(), "Timer set to %s", timerSeconds);
            this.saveGame(game);
        }, new ExecutorType[0])))).then(LiteralArgument.literal("min_players").then((AbstractArgumentTree)new IntegerArgument("min", 2).executes(info -> {
            Game game = CustomArg.getGame(info);
            int minPlayers = info.args().getByClass("min", Integer.class);
            if (minPlayers > game.getGameArenaData().getMaxPlayers()) {
                throw CommandAPI.failWithString("Min players cannot be greater than max players");
            }
            game.getGameArenaData().setMinPlayers(minPlayers);
            Util.sendPrefixedMessage((CommandSender)info.sender(), "Min players set to %s", minPlayers);
            this.saveGame(game);
        }, new ExecutorType[0])))).then(LiteralArgument.literal("max_players").then((AbstractArgumentTree)new IntegerArgument("max", 2).executes(info -> {
            Game game = CustomArg.getGame(info);
            int maxPlayers = info.args().getByClass("max", Integer.class);
            if (maxPlayers < game.getGameArenaData().getMinPlayers()) {
                throw CommandAPI.failWithString("Max players cannot be less than min players");
            }
            game.getGameArenaData().setMaxPlayers(maxPlayers);
            Util.sendPrefixedMessage((CommandSender)info.sender(), "Max players set to %s", maxPlayers);
            this.saveGame(game);
        }, new ExecutorType[0])));
    }

    private Argument<?> locations() {
        return (Argument)((Argument)((Argument)LiteralArgument.literal("locations").then((AbstractArgumentTree)LiteralArgument.literal("lobby_wall").executesPlayer(info -> {
            Game game = CustomArg.getGame(info);
            Player player = (Player)info.sender();
            Block targetBlock = player.getTargetBlockExact(10);
            if (targetBlock != null && Tag.WALL_SIGNS.isTagged((Keyed)targetBlock.getType()) && game.getGameBlockData().setLobbyBlock(targetBlock.getLocation())) {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_edit_lobbywall_set, new Object[0]);
                this.saveGame(game);
            } else {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_edit_lobbywall_incorrect, new Object[0]);
                Util.sendMessage((CommandSender)player, this.lang.command_edit_lobbywall_format, new Object[0]);
            }
        }))).then((AbstractArgumentTree)LiteralArgument.literal("clear_spawns").executes(info -> {
            Game game = CustomArg.getGame(info);
            game.getGameArenaData().clearSpawns();
            Util.sendPrefixedMessage((CommandSender)info.sender(), "Spawns have been cleared. <yellow>Arena <white>'<aqua>%s<white>'<yellow> has a max of <red>%s<yellow> players, so make sure to add spawns for them.", game.getGameArenaData().getName(), game.getGameArenaData().getMaxPlayers());
            this.saveGame(game);
        }, new ExecutorType[0]))).then(LiteralArgument.literal("add_spawn").then((AbstractArgumentTree)new LocationArgument("location", LocationType.BLOCK_POSITION).executesPlayer(info -> {
            Game game = CustomArg.getGame(info);
            GameArenaData gameArenaData = game.getGameArenaData();
            Location location = info.args().getByClass("location", Location.class);
            assert (location != null);
            location.add(0.5, 0.0, 0.5);
            location.setPitch(0.0f);
            location.setYaw(((Player)info.sender()).getLocation().getYaw());
            gameArenaData.addSpawn(location);
            int spawnCount = gameArenaData.getSpawns().size();
            int maxPlayers = gameArenaData.getMaxPlayers();
            if (spawnCount < maxPlayers) {
                Util.sendPrefixedMessage((CommandSender)info.sender(), "<yellow>You currently have <aqua>%s <yellow>spawns but a max of <red>%s <yellow>players, you should add <green>%s<yellow> more spawns", spawnCount, maxPlayers, maxPlayers - spawnCount);
            } else {
                Util.sendPrefixedMessage((CommandSender)info.sender(), "<green>Spawns all set!", new Object[0]);
            }
            this.saveGame(game);
        })));
    }

    private Location convert(Location2D location2D) {
        return new Location(location2D.getWorld(), (double)location2D.getBlockX(), 0.0, (double)location2D.getBlockZ());
    }
}

