/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.commands;

import com.shanebeestudios.hg.api.command.CustomArg;
import com.shanebeestudios.hg.api.commandapi.AbstractArgumentTree;
import com.shanebeestudios.hg.api.commandapi.arguments.Argument;
import com.shanebeestudios.hg.api.commandapi.arguments.LiteralArgument;
import com.shanebeestudios.hg.api.commandapi.executors.CommandArguments;
import com.shanebeestudios.hg.api.commandapi.executors.ExecutorType;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.status.Status;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.commands.SubCommand;
import com.shanebeestudios.hg.plugin.permission.Permissions;
import org.bukkit.command.CommandSender;

public class ForceStartCommand
extends SubCommand {
    public ForceStartCommand(HungerGames plugin) {
        super(plugin);
    }

    @Override
    protected Argument<?> register() {
        return (Argument)((Argument)LiteralArgument.literal("forcestart").withPermission(Permissions.COMMAND_FORCE_START.permission())).then((AbstractArgumentTree)CustomArg.GAME.get("game").executes(info -> {
            CommandSender sender = (CommandSender)info.sender();
            CommandArguments args = info.args();
            Game game = args.getByClass("game", Game.class);
            if (game != null) {
                Status status = game.getGameArenaData().getStatus();
                if (status == Status.WAITING || status == Status.READY) {
                    game.startPreGameCountdown();
                    Util.sendMessage(sender, this.lang.cmd_start_starting.replace("<arena>", game.getGameArenaData().getName()), new Object[0]);
                } else if (status == Status.COUNTDOWN) {
                    game.getStartingTask().stop();
                    game.startFreeRoam();
                    Util.sendMessage(sender, "<green>Game starting now", new Object[0]);
                } else {
                    Util.sendMessage(sender, "<red>Game has already started", new Object[0]);
                }
            } else {
                Util.sendPrefixedMessage(sender, this.lang.command_delete_no_exist.replace("<arena>", args.getRaw("game")), new Object[0]);
            }
        }, new ExecutorType[0]));
    }
}

