/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.commands;

import com.shanebeestudios.hg.api.command.CustomArg;
import com.shanebeestudios.hg.api.commandapi.AbstractArgumentTree;
import com.shanebeestudios.hg.api.commandapi.arguments.Argument;
import com.shanebeestudios.hg.api.commandapi.arguments.EntitySelectorArgument;
import com.shanebeestudios.hg.api.commandapi.arguments.LiteralArgument;
import com.shanebeestudios.hg.api.commandapi.executors.CommandArguments;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.commands.SubCommand;
import com.shanebeestudios.hg.plugin.permission.Permissions;
import java.util.Collection;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class JoinCommand
extends SubCommand {
    public JoinCommand(HungerGames plugin) {
        super(plugin);
    }

    @Override
    protected Argument<?> register() {
        return (Argument)((Argument)LiteralArgument.literal("join").withPermission(Permissions.COMMAND_JOIN.permission())).then(CustomArg.GAME.get("game").then((AbstractArgumentTree)((Argument)((Argument)new EntitySelectorArgument.ManyPlayers("players").setOptional(true)).withPermission(Permissions.COMMAND_JOIN_OTHERS.permission())).executesPlayer(info -> {
            Player sender = (Player)info.sender();
            CommandArguments args = info.args();
            Game game = args.getByClass("game", Game.class);
            if (game != null) {
                Collection players = args.getByClass("players", Collection.class);
                if (players != null) {
                    players.forEach(player -> this.joinGame((CommandSender)sender, (Player)player, game));
                } else {
                    this.joinGame((CommandSender)sender, sender, game);
                }
            } else {
                Util.sendPrefixedMessage((CommandSender)sender, "Invalid game: %s", args.getRaw("game"));
            }
        })));
    }

    private void joinGame(CommandSender sender, Player player, Game game) {
        if (this.playerManager.isInGame(player)) {
            if (sender == player) {
                Util.sendPrefixedMessage(sender, this.lang.command_join_already_in_game, new Object[0]);
            } else {
                Util.sendPrefixedMessage(sender, this.lang.command_join_already_in_game_other.replace("<player>", player.getName()), new Object[0]);
            }
            return;
        }
        game.joinGame(player, true);
    }
}

