/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.commands;

import com.shanebeestudios.hg.api.commandapi.arguments.Argument;
import com.shanebeestudios.hg.api.commandapi.arguments.LiteralArgument;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.gui.KitsGUI;
import com.shanebeestudios.hg.api.status.Status;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.commands.SubCommand;
import com.shanebeestudios.hg.plugin.permission.Permissions;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class KitsCommand
extends SubCommand {
    public KitsCommand(HungerGames plugin) {
        super(plugin);
    }

    @Override
    protected Argument<?> register() {
        return (Argument)((Argument)LiteralArgument.literal("kits").withPermission(Permissions.COMMAND_KIT.permission())).executesPlayer(info -> {
            Player player = (Player)info.sender();
            Game game = this.plugin.getPlayerManager().getGame(player);
            if (game == null) {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_base_not_in_valid_game, new Object[0]);
                return;
            }
            Status status = game.getGameArenaData().getStatus();
            if (status != Status.WAITING && status != Status.COUNTDOWN) {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_kit_game_running, new Object[0]);
                return;
            }
            KitsGUI kitsGUI = new KitsGUI(game, player);
            kitsGUI.open();
        });
    }
}

