/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.commands;

import com.shanebeestudios.hg.api.commandapi.arguments.Argument;
import com.shanebeestudios.hg.api.commandapi.arguments.LiteralArgument;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameArenaData;
import com.shanebeestudios.hg.api.status.Status;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.api.util.Vault;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.commands.SubCommand;
import com.shanebeestudios.hg.plugin.configs.Config;
import com.shanebeestudios.hg.plugin.permission.Permissions;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LeaveCommand
extends SubCommand {
    public LeaveCommand(HungerGames plugin) {
        super(plugin);
    }

    @Override
    protected Argument<?> register() {
        return (Argument)((Argument)LiteralArgument.literal("leave").withPermission(Permissions.COMMAND_LEAVE.permission())).executesPlayer(info -> {
            Game game;
            Player player = (Player)info.sender();
            if (this.playerManager.hasPlayerData(player)) {
                game = this.playerManager.getPlayerData(player).getGame();
                if (Config.economy) {
                    GameArenaData gameArenaData = game.getGameArenaData();
                    Status status = gameArenaData.getStatus();
                    int cost = gameArenaData.getCost();
                    if ((status == Status.WAITING || status == Status.COUNTDOWN) && cost > 0) {
                        Vault.economy.depositPlayer((OfflinePlayer)player, (double)cost);
                        Util.sendMessage((CommandSender)player, this.lang.command_leave_refund.replace("<cost>", String.valueOf(cost)), new Object[0]);
                    }
                }
                game.getGamePlayerData().leaveGame(player, false);
            } else if (this.playerManager.hasSpectatorData(player)) {
                game = this.playerManager.getSpectatorData(player).getGame();
                game.getGamePlayerData().leaveSpectate(player);
            } else {
                Util.sendMessage((CommandSender)player, this.lang.command_base_not_in_valid_game, new Object[0]);
                return;
            }
            Util.sendMessage((CommandSender)player, this.lang.command_leave_left.replace("<arena>", game.getGameArenaData().getName()), new Object[0]);
        });
    }
}

