/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.commands;

import com.shanebeestudios.hg.api.commandapi.AbstractArgumentTree;
import com.shanebeestudios.hg.api.commandapi.arguments.Argument;
import com.shanebeestudios.hg.api.commandapi.arguments.LiteralArgument;
import com.shanebeestudios.hg.api.nbt.NBT;
import com.shanebeestudios.hg.api.nbt.iface.ReadWriteNBT;
import com.shanebeestudios.hg.api.util.NBTApi;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.commands.SubCommand;
import com.shanebeestudios.hg.plugin.permission.Permissions;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class NBTCommand
extends SubCommand {
    public NBTCommand(HungerGames plugin) {
        super(plugin);
    }

    @Override
    protected Argument<?> register() {
        return (Argument)((Argument)((Argument)LiteralArgument.literal("nbt").withPermission(Permissions.COMMAND_NBT.permission())).then((AbstractArgumentTree)LiteralArgument.literal("item").executesPlayer(info -> {
            Player player = (Player)info.sender();
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            if (itemStack.getType() == Material.AIR) {
                Util.sendPrefixedMessage((CommandSender)player, "<red>You cannot get NBT from an empty hand.", new Object[0]);
                return;
            }
            NBT.getComponents(itemStack, readableNBT -> {
                Util.sendPrefixedMessage((CommandSender)player, "NBT of held item sent to console!", new Object[0]);
                Util.log("NBT: %s", readableNBT.toString());
                String pretty = NBTApi.getPrettyNBT(readableNBT.toString(), "   ");
                if (pretty != null) {
                    Util.log("Pretty NBT:", new Object[0]);
                    Bukkit.getConsoleSender().sendMessage(System.lineSeparator() + pretty);
                }
            });
        }))).then((AbstractArgumentTree)LiteralArgument.literal("entity").executesPlayer(info -> {
            Player player = (Player)info.sender();
            Entity targetEntity = player.getTargetEntity(50);
            if (targetEntity == null) {
                Util.sendPrefixedMessage((CommandSender)player, "<red>Target entity not found.", new Object[0]);
                return;
            }
            EntitySnapshot snapshot = targetEntity.createSnapshot();
            assert (snapshot != null);
            ReadWriteNBT nbtCopy = NBT.parseNBT(snapshot.getAsString());
            Util.sendPrefixedMessage((CommandSender)player, "NBT of target entity sent to console!", new Object[0]);
            Util.log("NBT: %s", nbtCopy.toString());
            String pretty = NBTApi.getPrettyNBT(nbtCopy.toString(), "   ");
            if (pretty != null) {
                Util.log("Pretty NBT:", new Object[0]);
                Bukkit.getConsoleSender().sendMessage(System.lineSeparator() + pretty);
            }
        }));
    }
}

