/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.commands;

import com.shanebeestudios.hg.api.commandapi.AbstractArgumentTree;
import com.shanebeestudios.hg.api.commandapi.BukkitStringTooltip;
import com.shanebeestudios.hg.api.commandapi.arguments.Argument;
import com.shanebeestudios.hg.api.commandapi.arguments.ArgumentSuggestions;
import com.shanebeestudios.hg.api.commandapi.arguments.LiteralArgument;
import com.shanebeestudios.hg.api.commandapi.arguments.StringArgument;
import com.shanebeestudios.hg.api.commandapi.executors.ExecutorType;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.commands.SubCommand;
import com.shanebeestudios.hg.plugin.configs.Config;
import com.shanebeestudios.hg.plugin.permission.Permissions;
import java.util.List;
import java.util.Optional;
import org.bukkit.command.CommandSender;

public class SettingsCommand
extends SubCommand {
    public SettingsCommand(HungerGames plugin) {
        super(plugin);
    }

    @Override
    protected Argument<?> register() {
        return (Argument)((Argument)LiteralArgument.literal("settings").withPermission(Permissions.COMMAND_SETTINGS.permission())).then(this.debug());
    }

    private Argument<?> debug() {
        return (Argument)LiteralArgument.literal("debug").then((AbstractArgumentTree)((Argument)((Argument)new StringArgument("enable").setOptional(true)).includeSuggestions(ArgumentSuggestions.stringsWithTooltips(List.of(BukkitStringTooltip.ofString("enable", "Enable the debug setting"), BukkitStringTooltip.ofString("disable", "Disable the debug setting"))))).executes(info -> {
            CommandSender sender = (CommandSender)info.sender();
            Optional<String> enable = info.args().getOptionalByClass("enable", String.class);
            if (enable.isPresent()) {
                String s = enable.get();
                if (s.equalsIgnoreCase("enable")) {
                    Config.SETTINGS_DEBUG = true;
                    Util.sendPrefixedMessage(sender, "The debug setting has been <green>enabled<grey>!", new Object[0]);
                } else if (s.equalsIgnoreCase("disable")) {
                    Config.SETTINGS_DEBUG = false;
                    Util.sendPrefixedMessage(sender, "The debug setting has been <red>disabled<grey>!", new Object[0]);
                } else {
                    Util.sendPrefixedMessage(sender, "Invalid option '%s'", s);
                }
            } else {
                String setting = Config.SETTINGS_DEBUG ? "<green>enabled" : "<red>disabled";
                Util.sendPrefixedMessage(sender, "The debug setting is %s", setting);
            }
        }, new ExecutorType[0]));
    }
}

