/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.commands;

import com.shanebeestudios.hg.api.commandapi.AbstractArgumentTree;
import com.shanebeestudios.hg.api.commandapi.arguments.Argument;
import com.shanebeestudios.hg.api.commandapi.arguments.EntitySelectorArgument;
import com.shanebeestudios.hg.api.commandapi.arguments.LiteralArgument;
import com.shanebeestudios.hg.api.commandapi.arguments.StringArgument;
import com.shanebeestudios.hg.api.data.PlayerData;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameTeam;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.commands.SubCommand;
import com.shanebeestudios.hg.plugin.configs.Config;
import com.shanebeestudios.hg.plugin.permission.Permissions;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class TeamCommand
extends SubCommand {
    public TeamCommand(HungerGames plugin) {
        super(plugin);
    }

    @Override
    protected Argument<?> register() {
        return (Argument)((Argument)((Argument)((Argument)((Argument)((Argument)LiteralArgument.literal("team").withPermission(Permissions.COMMAND_TEAM.permission())).then(LiteralArgument.literal("create").then((AbstractArgumentTree)new StringArgument("name").executesPlayer(info -> {
            Player player = (Player)info.sender();
            PlayerData playerData = this.playerManager.getPlayerData(player);
            if (playerData == null) {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_base_not_in_valid_game, new Object[0]);
                return;
            }
            GameTeam gameTeam = playerData.getTeam();
            if (gameTeam != null) {
                String exists = this.lang.command_team_already_have.replace("<name>", gameTeam.getTeamName());
                Util.sendMessage((CommandSender)player, exists, new Object[0]);
            } else {
                String teamName = info.args().getByClass("name", String.class);
                assert (teamName != null);
                Game game = playerData.getGame();
                if (game.getGameScoreboard().hasGameTeam(teamName)) {
                    String exists = this.lang.command_team_already_exists.replace("<name>", teamName);
                    Util.sendMessage((CommandSender)player, exists, new Object[0]);
                    return;
                }
                game.getGameScoreboard().createGameTeam(player, teamName);
                String created = this.lang.command_team_created.replace("<name>", teamName);
                Util.sendMessage((CommandSender)player, created, new Object[0]);
            }
        })))).then(LiteralArgument.literal("invite").then((AbstractArgumentTree)new EntitySelectorArgument.OnePlayer("player").executesPlayer(info -> {
            Player teamLeader = (Player)info.sender();
            PlayerData playerData = this.playerManager.getPlayerData(teamLeader);
            if (playerData == null) {
                Util.sendPrefixedMessage((CommandSender)teamLeader, this.lang.command_base_not_in_valid_game, new Object[0]);
                return;
            }
            GameTeam gameTeam = playerData.getTeam();
            if (gameTeam == null) {
                Util.sendMessage((CommandSender)teamLeader, this.lang.command_team_none, new Object[0]);
                return;
            }
            Game game = playerData.getGame();
            Player invitee = info.args().getByClass("player", Player.class);
            assert (invitee != null);
            if (!game.getGamePlayerData().getPlayers().contains(invitee)) {
                Util.sendMessage((CommandSender)teamLeader, this.lang.command_team_player_not_available.replace("<player>", teamLeader.getName()), new Object[0]);
                return;
            }
            if (invitee == teamLeader) {
                Util.sendMessage((CommandSender)teamLeader, this.lang.command_team_self, new Object[0]);
                return;
            }
            if (gameTeam.getLeader() != teamLeader) {
                Util.sendMessage((CommandSender)teamLeader, this.lang.command_team_only_leader, new Object[0]);
                return;
            }
            if (gameTeam.isOnTeam(invitee)) {
                Util.sendMessage((CommandSender)teamLeader, this.lang.command_team_on_team.replace("<player>", invitee.getName()), new Object[0]);
                return;
            }
            if (gameTeam.getPlayers().size() + gameTeam.getPendingPlayers().size() >= Config.TEAM_MAX_TEAM_SIZE) {
                Util.sendMessage((CommandSender)teamLeader, this.lang.command_team_max, new Object[0]);
                return;
            }
            gameTeam.invite(invitee);
            Util.sendMessage((CommandSender)teamLeader, this.lang.command_team_invited.replace("<player>", invitee.getName()), new Object[0]);
        })))).then((AbstractArgumentTree)LiteralArgument.literal("accept").executesPlayer(info -> {
            Player player = (Player)info.sender();
            PlayerData playerData = this.playerManager.getPlayerData(player);
            if (playerData == null) {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_base_not_in_valid_game, new Object[0]);
                return;
            }
            GameTeam gameTeam = playerData.getPendingTeam();
            if (gameTeam == null || !gameTeam.isPending(player)) {
                Util.sendMessage((CommandSender)player, this.lang.command_team_no_pend, new Object[0]);
                return;
            }
            gameTeam.acceptInvite(player);
            gameTeam.messageMembers("<gold>*<aqua><strikethrough>                                                                             <gold>*");
            gameTeam.messageMembers(this.lang.command_team_joined.replace("<player>", player.getName()));
            gameTeam.messageMembers("<gold>*<aqua><strikethrough>                                                                             <gold>*");
        }))).then((AbstractArgumentTree)LiteralArgument.literal("deny").executesPlayer(info -> {
            Player player = (Player)info.sender();
            PlayerData playerData = this.playerManager.getPlayerData(player);
            if (playerData == null) {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_base_not_in_valid_game, new Object[0]);
                return;
            }
            GameTeam gameTeam = playerData.getPendingTeam();
            if (gameTeam == null || !gameTeam.isPending(player)) {
                Util.sendMessage((CommandSender)player, this.lang.command_team_no_pend, new Object[0]);
                return;
            }
            gameTeam.declineInvite(player);
        }))).then(((Argument)LiteralArgument.literal("teleport").withPermission(Permissions.COMMAND_TEAM_TELEPORT.permission())).then((AbstractArgumentTree)new EntitySelectorArgument.OnePlayer("player").executesPlayer(info -> {
            Player player = (Player)info.sender();
            PlayerData playerData = this.playerManager.getPlayerData(player);
            if (playerData == null) {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_base_not_in_valid_game, new Object[0]);
                return;
            }
            GameTeam gameTeam = playerData.getTeam();
            if (gameTeam == null) {
                Util.sendMessage((CommandSender)player, this.lang.command_team_none, new Object[0]);
                return;
            }
            Player tpTo = info.args().getByClass("player", Player.class);
            assert (tpTo != null);
            if (gameTeam.isOnTeam(tpTo)) {
                player.teleport((Entity)tpTo);
                Util.sendMessage((CommandSender)player, this.lang.command_team_tp.replace("<player>", tpTo.getName()), new Object[0]);
            } else {
                Util.sendMessage((CommandSender)player, this.lang.command_team_not_on_team.replace("<player>", tpTo.getName()), new Object[0]);
            }
        })));
    }
}

