/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.configs;

import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameArenaData;
import com.shanebeestudios.hg.api.game.GameBorderData;
import com.shanebeestudios.hg.api.game.GameRegion;
import com.shanebeestudios.hg.api.parsers.LocationParser;
import com.shanebeestudios.hg.api.util.Pair;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.managers.GameManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Difficulty;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.ApiStatus;

public class ArenaConfig {
    private final HungerGames plugin;
    private final GameManager gameManager;
    private File arenaDirectory;
    private final Map<String, Pair<File, FileConfiguration>> fileConfigMap = new HashMap<String, Pair<File, FileConfiguration>>();

    @ApiStatus.Internal
    public ArenaConfig(HungerGames plugin) {
        this.plugin = plugin;
        this.gameManager = plugin.getGameManager();
        this.loadAllArenas();
    }

    private Pair<File, FileConfiguration> getOrCreateConfig(String name) {
        if (this.fileConfigMap.containsKey(name)) {
            return this.fileConfigMap.get(name);
        }
        File file = new File(this.arenaDirectory, name + ".yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        Pair<File, YamlConfiguration> fileConfig = Pair.of(file, config);
        this.fileConfigMap.put(name, fileConfig);
        return fileConfig;
    }

    private void saveArenaConfig(String name) {
        Pair<File, FileConfiguration> fileConfig = this.fileConfigMap.get(name);
        try {
            fileConfig.second().save(fileConfig.first());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void loadAllArenas() {
        Util.log("Loading arenas:", new Object[0]);
        this.arenaDirectory = new File(this.plugin.getDataFolder(), "arenas");
        if (!this.arenaDirectory.exists() && !this.arenaDirectory.mkdirs()) {
            Util.warning("Could not create arenas directory!", new Object[0]);
        }
        int count = 0;
        for (File arenaFile : this.arenaDirectory.listFiles()) {
            String name = arenaFile.getName();
            if (!name.endsWith(".yml")) continue;
            YamlConfiguration arenaConfig = YamlConfiguration.loadConfiguration((File)arenaFile);
            name = name.replace(".yml", "");
            this.loadArena((FileConfiguration)arenaConfig, name);
            this.fileConfigMap.put(name, Pair.of(arenaFile, arenaConfig));
            ++count;
        }
        if (count > 0) {
            Util.log("- <aqua>%s <grey>arenas have been <green>successfully loaded!", count);
        } else {
            Util.log("- <red>No Arenas found. <grey>Time to create some!", new Object[0]);
        }
    }

    public void loadArena(FileConfiguration arenaConfig, String arenaName) {
        boolean isReady = true;
        ArrayList<Location> spawns = new ArrayList<Location>();
        Location lobbysign = null;
        int timer = 0;
        int cost = 0;
        int minPlayers = 0;
        int maxPlayers = 0;
        int freeRoamTime = 0;
        GameRegion gameRegion = null;
        ConfigurationSection infoSection = arenaConfig.getConfigurationSection("info");
        try {
            timer = infoSection.getInt("timer");
            minPlayers = infoSection.getInt("min_players");
            maxPlayers = infoSection.getInt("max_players");
            freeRoamTime = infoSection.getInt("free_roam_time");
        }
        catch (Exception e) {
            Util.warning("Unable to load information for arena '" + arenaName + "'!", new Object[0]);
            isReady = false;
        }
        try {
            cost = infoSection.getInt("cost");
        }
        catch (Exception e) {
            // empty catch block
        }
        ConfigurationSection locationsSection = arenaConfig.getConfigurationSection("locations");
        try {
            lobbysign = LocationParser.getBlockLocFromString(locationsSection.getString("lobby_sign"));
        }
        catch (Exception e) {
            Util.warning("Unable to load lobby sign for arena '" + arenaName + "'!", new Object[0]);
            Util.debug(e);
            isReady = false;
        }
        try {
            for (String location : locationsSection.getStringList("spawns")) {
                spawns.add(LocationParser.getLocFromString(location));
            }
        }
        catch (Exception e) {
            Util.warning("Unable to load random spawns for arena '" + arenaName + "'!", new Object[0]);
            isReady = false;
        }
        try {
            ConfigurationSection regionSection = arenaConfig.getConfigurationSection("region");
            String world = regionSection.getString("world");
            BoundingBox boundingBox = (BoundingBox)regionSection.getObject("bounding_box", BoundingBox.class);
            gameRegion = GameRegion.loadFromConfig(world, boundingBox);
        }
        catch (Exception e) {
            Util.warning("Unable to load region bounds for arena " + arenaName + "!", new Object[0]);
            isReady = false;
        }
        Game game = new Game(arenaName, gameRegion, spawns, lobbysign, timer, minPlayers, maxPlayers, freeRoamTime, isReady, cost);
        this.gameManager.loadGameFromConfig(arenaName, game);
        GameArenaData gameArenaData = game.getGameArenaData();
        World world = gameRegion.getWorld();
        if (world.getDifficulty() == Difficulty.PEACEFUL) {
            Util.warning("Difficulty in world '%s' for arena '%s' is set to PEACEFUL...", world.getName(), arenaName);
            Util.warning("This can have negative effects on the game, please consider raising the difficulty.", new Object[0]);
        }
        this.plugin.getKitManager().loadGameKits(game, (ConfigurationSection)arenaConfig);
        this.plugin.getMobManager().loadGameMobs(game, (ConfigurationSection)arenaConfig);
        this.plugin.getItemManager().loadGameItems(game, (ConfigurationSection)arenaConfig);
        if (arenaConfig.isSet("game_border")) {
            ConfigurationSection borderSection = arenaConfig.getConfigurationSection("game_border");
            GameBorderData gameBorderData = game.getGameBorderData();
            if (borderSection.isSet("center_location")) {
                Location borderCenter = LocationParser.getBlockLocFromString(borderSection.getString("center_location"));
                gameBorderData.setCenterLocation(borderCenter);
            }
            if (borderSection.isSet("final_size")) {
                int borderSize = borderSection.getInt("final_size");
                gameBorderData.setFinalBorderSize(borderSize);
            }
            if (borderSection.isSet("countdown_start") && borderSection.isSet("countdown_end")) {
                int countdownStart = borderSection.getInt("countdown_start");
                int countdownEnd = borderSection.getInt("countdown_end");
                gameBorderData.setBorderCountdownStart(countdownStart);
                gameBorderData.setBorderCountdownEnd(countdownEnd);
            }
        }
        List commands = arenaConfig.isSet("commands") ? arenaConfig.getStringList("commands") : Collections.singletonList("none");
        game.getGameCommandData().setCommands(commands);
        if (arenaConfig.isConfigurationSection("chest_refill")) {
            ConfigurationSection chestRefillSection = arenaConfig.getConfigurationSection("chest_refill");
            if (chestRefillSection.isSet("time")) {
                int chestRefill = chestRefillSection.getInt("time");
                gameArenaData.setChestRefillTime(chestRefill);
            }
            if (chestRefillSection.isSet("repeat")) {
                int chestRefillRepeat = chestRefillSection.getInt("repeat");
                gameArenaData.setChestRefillRepeat(chestRefillRepeat);
            }
        }
        try {
            if (locationsSection.isSet("exit")) {
                Location exitLocation = LocationParser.getLocFromString(locationsSection.getString("exit"));
                gameArenaData.setExitLocation(exitLocation);
            }
        }
        catch (Exception exception) {
            Util.log("- <yellow>Failed to setup exit location for arena '%s', defaulting to spawn location of world '%s'", arenaName, world.getName());
            Util.debug(exception);
        }
        Util.log("- Loaded arena <white>'<aqua>%s<white>'<grey>", arenaName);
    }

    public void saveGameToConfig(Game game) {
        int chestRefillRepeat;
        String arenaName = game.getGameArenaData().getName();
        Pair<File, FileConfiguration> fileConfig = this.getOrCreateConfig(arenaName);
        FileConfiguration gameSection = fileConfig.second();
        GameArenaData gameArenaData = game.getGameArenaData();
        ConfigurationSection chestRefillSection = gameSection.createSection("chest_refill");
        int chestRefillTime = gameArenaData.getChestRefillTime();
        if (chestRefillTime > 0) {
            chestRefillSection.set("time", (Object)chestRefillTime);
        }
        if ((chestRefillRepeat = gameArenaData.getChestRefillRepeat()) > 0) {
            chestRefillSection.set("repeat", (Object)chestRefillRepeat);
        }
        ConfigurationSection infoSection = gameSection.createSection("info");
        infoSection.set("cost", (Object)gameArenaData.getCost());
        infoSection.set("timer", (Object)gameArenaData.getTimer());
        infoSection.set("min_players", (Object)gameArenaData.getMinPlayers());
        infoSection.set("max_players", (Object)gameArenaData.getMaxPlayers());
        infoSection.set("free_roam_time", (Object)gameArenaData.getFreeRoamTime());
        ConfigurationSection regionSection = gameSection.createSection("region");
        regionSection.set("world", (Object)gameArenaData.getGameRegion().getWorld().getName());
        regionSection.set("bounding_box", (Object)gameArenaData.getGameRegion().getBoundingBox());
        gameSection.set("commands", game.getGameCommandData().getCommands());
        ConfigurationSection locationsSection = gameSection.createSection("locations");
        ArrayList spawns = new ArrayList();
        gameArenaData.getSpawns().forEach(spawn -> spawns.add(LocationParser.locToString(spawn)));
        locationsSection.set("spawns", spawns);
        Location exit = gameArenaData.getExitLocation();
        if (exit != null) {
            locationsSection.set("exit", (Object)LocationParser.blockLocToString(exit));
        }
        locationsSection.set("lobby_sign", (Object)LocationParser.blockLocToString(game.getLobbyLocation()));
        GameBorderData borderData = game.getGameBorderData();
        if (!borderData.isDefault()) {
            ConfigurationSection borderSection = gameSection.createSection("game_border");
            Location centerLocation = borderData.getCenterLocation();
            if (centerLocation != null) {
                String locString = LocationParser.blockLocToString(centerLocation);
                borderSection.set("center_location", (Object)locString);
            }
            borderSection.set("final_size", (Object)borderData.getFinalBorderSize());
            borderSection.set("countdown_start", (Object)borderData.getBorderCountdownStart());
            borderSection.set("countdown_end", (Object)borderData.getBorderCountdownEnd());
        }
        this.saveArenaConfig(arenaName);
    }

    public void removeArena(Game game) {
        String name = game.getGameArenaData().getName();
        Pair<File, FileConfiguration> fileFileConfigurationPair = this.fileConfigMap.get(name);
        fileFileConfigurationPair.first().delete();
        this.fileConfigMap.remove(name);
    }
}

