/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.listeners;

import com.shanebeestudios.hg.api.data.ItemData;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameArenaData;
import com.shanebeestudios.hg.api.game.GameBlockData;
import com.shanebeestudios.hg.api.status.Status;
import com.shanebeestudios.hg.api.util.BlockUtils;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.configs.Config;
import com.shanebeestudios.hg.plugin.listeners.GameListenerBase;
import com.shanebeestudios.hg.plugin.permission.Permissions;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class GameBlockListener
extends GameListenerBase {
    public GameBlockListener(HungerGames plugin) {
        super(plugin);
        BlockUtils.setupBuilder();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void onAttack(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Hanging) {
            Hanging hanging = (Hanging)entity;
            this.handleItemFrame(hanging, (Event)event, !Config.ROLLBACK_ALLOW_ITEMFRAME_TAKE);
        }
    }

    @EventHandler
    private void hangingPopOff(HangingBreakEvent event) {
        this.handleItemFrame(event.getEntity(), (Event)event, event instanceof HangingBreakByEntityEvent);
    }

    private void handleItemFrame(Hanging hanging, Event event, boolean cancel) {
        if (this.gameManager.isInRegion(hanging.getLocation())) {
            Game game = this.gameManager.getGame(hanging.getLocation());
            switch (game.getGameArenaData().getStatus()) {
                case RUNNING: 
                case FREE_ROAM: 
                case COUNTDOWN: {
                    if (cancel && event instanceof Cancellable) {
                        Cancellable cancellable = (Cancellable)event;
                        cancellable.setCancelled(true);
                        break;
                    }
                    if (!(hanging instanceof ItemFrame)) break;
                    ItemFrame itemFrame = (ItemFrame)hanging;
                    game.getGameBlockData().recordItemFrame(itemFrame);
                }
            }
        }
    }

    @EventHandler
    private void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (this.playerManager.hasSpectatorData(player)) {
            event.setCancelled(true);
            return;
        }
        if (!this.playerManager.hasPlayerData(player)) {
            if (this.gameManager.isInRegion(block.getLocation()) && !Permissions.COMMAND_CREATE.has((CommandSender)player)) {
                event.setCancelled(true);
            }
            return;
        }
        Game game = this.playerManager.getPlayerData(player).getGame();
        GameArenaData gameArenaData = game.getGameArenaData();
        if (gameArenaData.getGameRegion().isInRegion(block.getLocation())) {
            if (Config.ROLLBACK_ALLOW_BREAK_BLOCKS) {
                GameBlockData gameBlockData = game.getGameBlockData();
                Status status = gameArenaData.getStatus();
                if (status == Status.RUNNING || status == Status.ROLLBACK && !Config.ROLLBACK_PROTECT_DURING_FREE_ROAM) {
                    if (!BlockUtils.isEditableBlock(block.getType())) {
                        Util.sendMessage((CommandSender)player, this.lang.listener_no_edit_block, new Object[0]);
                        event.setCancelled(true);
                    } else if (this.isChest(block)) {
                        gameBlockData.logChest(ItemData.ChestType.PLAYER_PLACED, block.getLocation());
                    }
                } else {
                    Util.sendMessage((CommandSender)player, this.lang.listener_not_running, new Object[0]);
                    event.setCancelled(true);
                }
            } else if (!Permissions.COMMAND_CREATE.has((CommandSender)player)) {
                event.setCancelled(true);
            }
        } else {
            event.setCancelled(true);
        }
    }

    @EventHandler
    private void blockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (this.playerManager.hasSpectatorData(player)) {
            event.setCancelled(true);
            return;
        }
        if (!this.playerManager.hasPlayerData(player)) {
            if (this.gameManager.isInRegion(block.getLocation()) && !Permissions.COMMAND_CREATE.has((CommandSender)player)) {
                event.setCancelled(true);
            }
            return;
        }
        Game game = this.playerManager.getPlayerData(player).getGame();
        GameArenaData gameArenaData = game.getGameArenaData();
        if (gameArenaData.getGameRegion().isInRegion(block.getLocation())) {
            if (Config.ROLLBACK_ALLOW_BREAK_BLOCKS) {
                Status status = gameArenaData.getStatus();
                if (status == Status.RUNNING || status == Status.ROLLBACK && !Config.ROLLBACK_PROTECT_DURING_FREE_ROAM) {
                    if (!BlockUtils.isEditableBlock(block.getType())) {
                        Util.sendMessage((CommandSender)player, this.lang.listener_no_edit_block, new Object[0]);
                        event.setCancelled(true);
                    } else if (this.isChest(block)) {
                        GameBlockData gameBlockData = game.getGameBlockData();
                        gameBlockData.removeChest(block.getLocation());
                    }
                } else {
                    Util.sendMessage((CommandSender)player, this.lang.listener_not_running, new Object[0]);
                    event.setCancelled(true);
                }
            } else {
                if (Permissions.COMMAND_CREATE.has((CommandSender)player)) {
                    Status status = gameArenaData.getStatus();
                    switch (status) {
                        case RUNNING: 
                        case FREE_ROAM: {
                            game.getGameBlockData().removeChest(block.getLocation());
                        }
                    }
                    return;
                }
                event.setCancelled(true);
            }
        } else {
            event.setCancelled(true);
        }
    }

    @EventHandler
    private void onBucketEmpty(PlayerBucketEmptyEvent event) {
        this.handleBucketEvent((PlayerBucketEvent)event, false);
    }

    @EventHandler
    private void onBucketFill(PlayerBucketFillEvent event) {
        this.handleBucketEvent((PlayerBucketEvent)event, true);
    }

    private void handleBucketEvent(PlayerBucketEvent event, boolean fill) {
        boolean LAVA;
        Block block = event.getBlock();
        Player player = event.getPlayer();
        boolean WATER = event.getBucket() == Material.WATER_BUCKET && BlockUtils.isEditableBlock(Material.WATER);
        boolean bl = LAVA = event.getBucket() == Material.LAVA_BUCKET && BlockUtils.isEditableBlock(Material.LAVA);
        if (this.gameManager.isInRegion(block.getLocation())) {
            if (Config.ROLLBACK_ALLOW_BREAK_BLOCKS && this.playerManager.hasPlayerData(player)) {
                Game game = this.playerManager.getPlayerData(player).getGame();
                if (game.getGameArenaData().getStatus() == Status.RUNNING || !Config.ROLLBACK_PROTECT_DURING_FREE_ROAM) {
                    if (fill && !BlockUtils.isEditableBlock(block.getType()) || !fill && !WATER && !LAVA) {
                        Util.sendMessage((CommandSender)player, this.lang.listener_no_edit_block, new Object[0]);
                        event.setCancelled(true);
                    }
                } else {
                    Util.sendMessage((CommandSender)player, this.lang.listener_not_running, new Object[0]);
                    event.setCancelled(true);
                }
            } else if (this.playerManager.hasPlayerData(player) || !Permissions.COMMAND_CREATE.has((CommandSender)player)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    private void onTrample(PlayerInteractEvent event) {
        if (!Config.ROLLBACK_PREVENT_TRAMPLING) {
            return;
        }
        Player player = event.getPlayer();
        if (this.playerManager.hasSpectatorData(player)) {
            event.setCancelled(true);
            return;
        }
        if (this.gameManager.isInRegion(player.getLocation()) && event.getAction() == Action.PHYSICAL) {
            assert (event.getClickedBlock() != null);
            Material block = event.getClickedBlock().getType();
            if (block == Material.FARMLAND) {
                event.setCancelled(true);
            }
        }
    }

    private boolean isChest(Block block) {
        return block.getType() == Material.CHEST || BlockUtils.isBonusBlock(block);
    }
}

