/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.listeners;

import com.shanebeestudios.hg.api.data.PlayerData;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.status.Status;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.listeners.GameListenerBase;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.PlayerInventory;

public class GameDamageListenerBase
extends GameListenerBase {
    public GameDamageListenerBase(HungerGames plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void onAttack(EntityDamageByEntityEvent event) {
        Player victimPlayer;
        PlayerData playerData;
        Player attackerPlayer;
        Entity victim = event.getEntity();
        Entity attacker = event.getDamager();
        if (attacker instanceof Player && this.playerManager.hasSpectatorData(attackerPlayer = (Player)attacker)) {
            event.setCancelled(true);
            return;
        }
        if (victim instanceof Player && (playerData = this.playerManager.getPlayerData(victimPlayer = (Player)victim)) != null) {
            Game game = playerData.getGame();
            if (game.getGameArenaData().getStatus() != Status.RUNNING) {
                event.setCancelled(true);
            } else if (event.getFinalDamage() >= victimPlayer.getHealth()) {
                if (this.hasTotem(victimPlayer)) {
                    return;
                }
                event.setCancelled(true);
                this.killManager.processDeath(victimPlayer, game, attacker, event.getDamageSource());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void onDeathByOther(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.playerManager.hasSpectatorData(player)) {
                event.setCancelled(true);
                player.setFireTicks(0);
                return;
            }
            if (event instanceof EntityDamageByEntityEvent) {
                return;
            }
            PlayerData playerData = this.playerManager.getPlayerData(player);
            if (playerData != null && event.getFinalDamage() >= player.getHealth()) {
                if (this.hasTotem(player)) {
                    return;
                }
                event.setCancelled(true);
                this.killManager.processDeath(player, playerData.getGame(), null, event.getDamageSource());
            }
        }
    }

    private boolean hasTotem(Player player) {
        PlayerInventory inv = player.getInventory();
        if (inv.getItemInMainHand() != null && inv.getItemInMainHand().getType() == Material.TOTEM_OF_UNDYING) {
            return true;
        }
        return inv.getItemInOffHand() != null && inv.getItemInOffHand().getType() == Material.TOTEM_OF_UNDYING;
    }
}

