/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.listeners;

import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameArenaData;
import com.shanebeestudios.hg.api.status.Status;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.listeners.GameListenerBase;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class GameEntityListener
extends GameListenerBase {
    public GameEntityListener(HungerGames plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void onTarget(EntityTargetEvent event) {
        Player player;
        Entity target = event.getTarget();
        if (target instanceof Player && this.playerManager.hasSpectatorData(player = (Player)target)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    private void onSpawn(EntitySpawnEvent event) {
        Entity entity = event.getEntity();
        Location location = event.getLocation();
        if (this.gameManager.isInRegion(location)) {
            Game game = this.gameManager.getGame(location);
            Status status = game.getGameArenaData().getStatus();
            if (entity instanceof LivingEntity && entity.getType() != EntityType.ARMOR_STAND) {
                if (status != Status.RUNNING) {
                    event.setCancelled(true);
                    return;
                }
                if (event instanceof CreatureSpawnEvent) {
                    CreatureSpawnEvent creatureSpawnEvent = (CreatureSpawnEvent)event;
                    switch (creatureSpawnEvent.getSpawnReason()) {
                        case DEFAULT: 
                        case NATURAL: {
                            event.setCancelled(true);
                            return;
                        }
                    }
                }
            }
            if (status.isActive()) {
                game.getGameEntityData().logEntity(entity);
            }
        }
    }

    @EventHandler
    private void onEntityShoot(EntityShootBowEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.hasMetadata("death-message")) {
            event.getProjectile().setMetadata("death-message", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)((MetadataValue)entity.getMetadata("death-message").get(0)).asString()));
        }
        if (entity instanceof Player && this.playerManager.hasPlayerData(entity.getUniqueId())) {
            event.getProjectile().setMetadata("shooter", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)entity.getName()));
        }
    }

    @EventHandler
    private void onExplode(EntityExplodeEvent event) {
        Location location = event.getLocation();
        if (this.gameManager.isInRegion(location)) {
            Game game = this.gameManager.getGame(location);
            assert (game != null);
            GameArenaData gameArenaData = game.getGameArenaData();
            ArrayList outside = new ArrayList();
            event.blockList().forEach(block -> {
                if (!gameArenaData.isInRegion(block.getLocation())) {
                    outside.add(block);
                }
            });
            event.blockList().removeAll(outside);
        }
    }

    @EventHandler
    private void onEntityRemoved(EntityRemoveEvent event) {
        if (event.getCause() == EntityRemoveEvent.Cause.PLUGIN) {
            return;
        }
        Entity entity = event.getEntity();
        Game game = this.gameManager.getGame(entity.getLocation());
        if (game == null) {
            return;
        }
        game.getGameEntityData().removeEntityFromLog(entity);
    }
}

