/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.listeners;

import com.shanebeestudios.hg.api.data.PlayerData;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameArenaData;
import com.shanebeestudios.hg.api.status.Status;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.configs.Config;
import com.shanebeestudios.hg.plugin.listeners.GameListenerBase;
import io.papermc.paper.event.player.AsyncChatEvent;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class GamePlayerListener
extends GameListenerBase {
    public GamePlayerListener(HungerGames plugin) {
        super(plugin);
    }

    @EventHandler
    private void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getAction() != Action.PHYSICAL && this.playerManager.hasPlayerData(player)) {
            PlayerData playerData = this.playerManager.getPlayerData(player);
            assert (playerData != null);
            Status status = playerData.getGame().getGameArenaData().getStatus();
            if (status != Status.RUNNING && status != Status.FREE_ROAM) {
                event.setCancelled(true);
                Util.sendMessage((CommandSender)player, this.lang.listener_no_interact, new Object[0]);
            }
        }
    }

    @EventHandler
    private void onLogout(PlayerQuitEvent event) {
        PlayerData playerData;
        Player player = event.getPlayer();
        if (this.playerManager.hasPlayerData(player)) {
            playerData = this.playerManager.getPlayerData(player);
            assert (playerData != null);
            playerData.setOnline(false);
            playerData.getGame().getGamePlayerData().leaveGame(player, false);
        }
        if (this.playerManager.hasSpectatorData(player)) {
            playerData = this.playerManager.getSpectatorData(player);
            assert (playerData != null);
            playerData.setOnline(false);
            playerData.getGame().getGamePlayerData().leaveSpectate(player);
        }
    }

    @EventHandler
    private void onPickup(EntityPickupItemEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && this.playerManager.hasSpectatorData(player = (Player)livingEntity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    private void onTeleportIntoArena(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        Location location = event.getTo();
        for (Game game : this.plugin.getGameManager().getGames()) {
            GameArenaData gameArenaData = game.getGameArenaData();
            if (!gameArenaData.isInRegion(location) || gameArenaData.getStatus() != Status.RUNNING || event.getCause() != PlayerTeleportEvent.TeleportCause.ENDER_PEARL || game.getGamePlayerData().getPlayers().contains(player) || game.getGamePlayerData().getSpectators().contains(player)) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    private void onChat(AsyncChatEvent event) {
        Player spectator;
        if (!Config.SPECTATE_CHAT && this.playerManager.hasSpectatorData(spectator = event.getPlayer())) {
            PlayerData data = this.playerManager.getSpectatorData(spectator);
            assert (data != null);
            Game game = data.getGame();
            for (Player player : game.getGamePlayerData().getPlayers()) {
                event.viewers().remove(player);
            }
        }
    }

    @EventHandler
    private void onDrop(PlayerDropItemEvent event) {
        Status status;
        Player player = event.getPlayer();
        PlayerData playerData = this.playerManager.getPlayerData(player);
        if (playerData != null && (status = playerData.getGame().getGameArenaData().getStatus()) != Status.FREE_ROAM && status != Status.RUNNING) {
            event.setCancelled(true);
        }
        if (this.playerManager.hasSpectatorData(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    private void onSprint(FoodLevelChangeEvent event) {
        Player player = (Player)event.getEntity();
        if (this.playerManager.hasSpectatorData(player)) {
            player.setFoodLevel(20);
            event.setCancelled(true);
        }
    }
}

