/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.managers;

import com.google.common.collect.ImmutableList;
import com.shanebeestudios.hg.api.command.CustomArg;
import com.shanebeestudios.hg.api.data.ItemData;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameArenaData;
import com.shanebeestudios.hg.api.game.GameRegion;
import com.shanebeestudios.hg.api.status.Status;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.configs.Config;
import com.shanebeestudios.hg.plugin.configs.Language;
import com.shanebeestudios.hg.plugin.managers.PlayerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class GameManager {
    private final HungerGames plugin;
    private final Map<String, Game> games = new HashMap<String, Game>();
    private final Language lang;
    private final Random random = new Random();
    private Location globalExitLocation;

    public GameManager(HungerGames plugin) {
        this.plugin = plugin;
        this.lang = plugin.getLang();
        CustomArg.init(this);
        this.globalExitLocation = Config.GLOBAL_EXIT_LOCATION;
    }

    public ImmutableList<Game> getGames() {
        return ImmutableList.copyOf(this.games.values());
    }

    public List<String> getGameNames() {
        return this.games.keySet().stream().sorted().collect(Collectors.toList());
    }

    public Location getGlobalExitLocation(@Nullable Player player) {
        Location respawnLocation;
        if (this.globalExitLocation != null) {
            return this.globalExitLocation;
        }
        if (player != null && (respawnLocation = player.getRespawnLocation()) != null) {
            return respawnLocation;
        }
        return ((World)Bukkit.getWorlds().getFirst()).getSpawnLocation();
    }

    public void setGlobalExitLocation(Location location) {
        this.globalExitLocation = location;
        this.plugin.getHGConfig().setGlobalExitLocation(location);
    }

    public void stopAllGames() {
        PlayerManager playerManager = this.plugin.getPlayerManager();
        ArrayList<Player> players = new ArrayList<Player>();
        for (Game game : this.games.values()) {
            game.cancelTasks();
            game.getGameBlockData().forceRollback();
            players.addAll(game.getGamePlayerData().getPlayers());
            players.addAll(game.getGamePlayerData().getSpectators());
        }
        for (Player player : players) {
            UUID uuid = player.getUniqueId();
            player.closeInventory();
            if (playerManager.hasPlayerData(uuid)) {
                playerManager.getPlayerData(uuid).getGame().getGamePlayerData().leaveGame(player, false);
                playerManager.removePlayerData(uuid);
            }
            if (!playerManager.hasSpectatorData(uuid)) continue;
            playerManager.getSpectatorData(uuid).getGame().getGamePlayerData().leaveSpectate(player);
            playerManager.removePlayerData(uuid);
        }
        this.games.clear();
    }

    public Game createGame(String name, Block corner1, Block corner2, List<Location> spawns, Location sign, int timer, int minPlayers, int maxPlayers, int cost) {
        GameRegion gameRegion = GameRegion.createNew(corner1, corner2);
        int roam = 1;
        boolean isReady = true;
        Game game = new Game(name, gameRegion, spawns, sign, timer, minPlayers, maxPlayers, roam, isReady, cost);
        this.games.put(name, game);
        this.plugin.getArenaConfig().saveGameToConfig(game);
        return game;
    }

    public void loadGameFromConfig(String name, Game game) {
        this.games.put(name, game);
    }

    public boolean checkGame(Game game, CommandSender sender) {
        GameArenaData gameArenaData = game.getGameArenaData();
        int minPlayers = gameArenaData.getMinPlayers();
        int maxPlayers = gameArenaData.getMaxPlayers();
        String name = gameArenaData.getName();
        boolean isReady = true;
        if (gameArenaData.getSpawns().size() < maxPlayers) {
            Util.sendPrefixedMessage(sender, this.lang.arena_debug_need_more_spawns.replace("<number>", "" + (maxPlayers - gameArenaData.getSpawns().size())), new Object[0]);
            isReady = false;
        }
        if (maxPlayers < minPlayers) {
            Util.sendPrefixedMessage(sender, this.lang.arena_debug_min_max_players.replace("<min>", "" + minPlayers).replace("<max>", "" + maxPlayers), new Object[0]);
            isReady = false;
        }
        if (!game.getGameBlockData().isLobbyValid()) {
            Util.sendPrefixedMessage(sender, this.lang.arena_debug_invalid_lobby, new Object[0]);
            Util.sendPrefixedMessage(sender, this.lang.arena_debug_set_lobby.replace("<arena>", name), new Object[0]);
            isReady = false;
        }
        if (isReady) {
            Util.sendPrefixedMessage(sender, this.lang.arena_debug_ready_run.replace("<arena>", name), new Object[0]);
            if (sender != null) {
                gameArenaData.setStatus(Status.READY);
            }
        }
        return isReady;
    }

    public void fillChests(Game game, Block block, ItemData.ChestType chestType) {
        Inventory inventory = ((InventoryHolder)block.getState()).getInventory();
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int slot = 0; slot <= 26; ++slot) {
            slots.add(slot);
        }
        Collections.shuffle(slots);
        inventory.clear();
        int min = switch (chestType) {
            default -> throw new MatchException(null, null);
            case ItemData.ChestType.REGULAR -> Config.CHESTS_REGULAR_MIN_CONTENT;
            case ItemData.ChestType.BONUS -> Config.CHESTS_BONUS_MIN_CONTENT;
            case ItemData.ChestType.PLAYER_PLACED -> 0;
            case ItemData.ChestType.CHEST_DROP -> Config.CHESTS_CHEST_DROP_MIN_CONTENT;
        };
        int max = switch (chestType) {
            default -> throw new MatchException(null, null);
            case ItemData.ChestType.REGULAR -> Config.CHESTS_REGULAR_MAX_CONTENT;
            case ItemData.ChestType.BONUS -> Config.CHESTS_BONUS_MAX_CONTENT;
            case ItemData.ChestType.PLAYER_PLACED -> 0;
            case ItemData.ChestType.CHEST_DROP -> Config.CHESTS_CHEST_DROP_MAX_CONTENT;
        };
        int c = this.random.nextInt(max) + 1;
        for (c = Math.max(c, min); c != 0; --c) {
            ItemStack it = this.randomItem(game, chestType);
            int slot = (Integer)slots.getFirst();
            slots.removeFirst();
            inventory.setItem(slot, it);
        }
    }

    public ItemStack randomItem(Game game, ItemData.ChestType chestType) {
        List<ItemStack> items = game.getGameItemData().getItemData().getItems(chestType);
        int r = items.size();
        if (r == 0) {
            return new ItemStack(Material.AIR);
        }
        int i = this.random.nextInt(r);
        return items.get(i);
    }

    public boolean isInRegion(Location location) {
        for (Game g : this.games.values()) {
            if (!g.getGameArenaData().isInRegion(location)) continue;
            return true;
        }
        return false;
    }

    public Game getGame(Location location) {
        for (Game g : this.games.values()) {
            if (!g.getGameArenaData().isInRegion(location)) continue;
            return g;
        }
        return null;
    }

    public Game getGame(String name) {
        return this.games.get(name);
    }

    public void deleteGame(Game game) {
        String name = game.getGameArenaData().getName();
        this.games.remove(name);
        this.plugin.getArenaConfig().removeArena(game);
    }

    public int gamesRunning() {
        int i = 0;
        for (Game game : this.games.values()) {
            switch (game.getGameArenaData().getStatus()) {
                case RUNNING: 
                case COUNTDOWN: 
                case FREE_ROAM: 
                case ROLLBACK: {
                    ++i;
                }
            }
        }
        return i;
    }
}

