/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.managers;

import com.shanebeestudios.hg.api.data.Leaderboard;
import com.shanebeestudios.hg.api.events.PlayerDeathGameEvent;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameCommandData;
import com.shanebeestudios.hg.api.game.GamePlayerData;
import com.shanebeestudios.hg.api.registry.Registries;
import com.shanebeestudios.hg.api.util.ItemUtils;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.configs.Config;
import com.shanebeestudios.hg.plugin.configs.Language;
import io.papermc.paper.datacomponent.DataComponentTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.Nullable;

public class KillManager {
    private final HungerGames plugin;
    private final Language lang;
    private final Leaderboard leaderboard;
    private final Map<EntityType, String> entityTypeMessages = new HashMap<EntityType, String>();
    private final Map<DamageType, String> damageTypeMessages = new HashMap<DamageType, String>();

    public KillManager(HungerGames plugin) {
        this.plugin = plugin;
        this.lang = plugin.getLang();
        this.leaderboard = plugin.getLeaderboard();
        this.lang.death_message_entity_types.forEach((entityTypeString, message) -> {
            NamespacedKey key = NamespacedKey.fromString((String)entityTypeString);
            if (key != null) {
                EntityType entityType = (EntityType)Registries.ENTITY_TYPE_REGISTRY.get(key);
                if (entityType != null) {
                    this.entityTypeMessages.put(entityType, (String)message);
                } else {
                    Util.warning("Invalid EntityType '%s', check lang file", key);
                }
            } else {
                Util.warning("Invalid key for EntityType '%s', check lang file", entityTypeString);
            }
        });
        this.lang.death_message_damage_types.forEach((damageTypeString, message) -> {
            NamespacedKey key = NamespacedKey.fromString((String)damageTypeString);
            if (key != null) {
                DamageType damageType = (DamageType)Registries.DAMAGE_TYPE_REGISTRY.get(key);
                if (damageType != null) {
                    this.damageTypeMessages.put(damageType, (String)message);
                } else {
                    Util.warning("Invalid DamageType '%s', check lang file", key);
                }
            } else {
                Util.warning("Invalid key for DamageType '%s', check lang file", damageTypeString);
            }
        });
    }

    public String getNaturalDeathString(DamageSource damageSource, Player victim) {
        String damageType = this.damageTypeMessages.get(damageSource.getDamageType());
        if (damageType != null) {
            return damageType.replace("<player>", victim.getName());
        }
        TranslatableComponent translatable = Component.translatable((String)damageSource.getDamageType().getTranslationKey());
        String cause = Util.unMini((Component)translatable);
        return this.lang.death_messages_other.replace("<player>", victim.getName()).replace("<cause>", cause);
    }

    public String getKillString(String victimName, DamageSource damageSource, Entity killer) {
        Projectile projectile;
        ProjectileSource projectileSource;
        if (killer.hasMetadata("death-message")) {
            return ((MetadataValue)killer.getMetadata("death-message").getFirst()).asString().replace("<player>", victimName);
        }
        if (killer instanceof Projectile && (projectileSource = (projectile = (Projectile)killer).getShooter()) instanceof Player) {
            Player playerShooter = (Player)projectileSource;
            return this.getPlayerKillString(victimName, playerShooter, projectile);
        }
        if (killer instanceof Player) {
            Player playerKiller = (Player)killer;
            return this.getPlayerKillString(victimName, playerKiller, null);
        }
        if (this.entityTypeMessages.containsKey(killer.getType())) {
            return this.entityTypeMessages.get(killer.getType()).replace("<player>", victimName);
        }
        TranslatableComponent translatable = Component.translatable((String)damageSource.getDamageType().getTranslationKey());
        String cause = Util.unMini((Component)translatable);
        return this.lang.death_messages_other.replace("<player>", victimName).replace("<cause>", cause);
    }

    private String getPlayerKillString(String victimName, Player killer, Projectile projectile) {
        String weaponName;
        if (projectile != null) {
            AbstractArrow arrow;
            ItemStack weapon;
            weaponName = projectile instanceof AbstractArrow ? ((weapon = (arrow = (AbstractArrow)projectile).getWeapon()) != null ? Util.unMini((Component)weapon.getData(DataComponentTypes.ITEM_NAME)) : Util.unMini((Component)arrow.getItemStack().getData(DataComponentTypes.ITEM_NAME))) : "bow and arrow";
        } else if (killer.getInventory().getItemInMainHand().getType() == Material.AIR) {
            weaponName = "fist";
        } else {
            ItemStack itemStack = killer.getInventory().getItemInMainHand();
            Component data = (Component)itemStack.getData(DataComponentTypes.ITEM_NAME);
            weaponName = Util.unMini(data);
        }
        return this.entityTypeMessages.get(EntityType.PLAYER).replace("<player>", victimName).replace("<killer>", killer.getName()).replace("<weapon>", weaponName);
    }

    public boolean isShotByPlayer(Entity projectile) {
        Projectile p;
        return projectile instanceof Projectile && (p = (Projectile)projectile).getShooter() instanceof Player;
    }

    @Nullable
    public Player getPlayerShooter(Projectile projectile) {
        ProjectileSource projectileSource = projectile.getShooter();
        if (projectileSource instanceof Player) {
            Player player = (Player)projectileSource;
            return player;
        }
        return null;
    }

    public void processDeath(Player player, Game game, Entity attacker, DamageSource damageSource) {
        List<ItemStack> drops = this.dropInventoryOfPlayer(player);
        player.setHealth(20.0);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            String deathString;
            GamePlayerData gamePlayerData = game.getGamePlayerData();
            DamageType damageType = damageSource.getDamageType();
            if (attacker instanceof Player) {
                Player attackerPlayer = (Player)attacker;
                gamePlayerData.addKill(attackerPlayer);
                this.leaderboard.addStat(attackerPlayer, Leaderboard.Stats.KILLS);
                deathString = this.getKillString(player.getName(), damageSource, attacker);
            } else if (attacker instanceof Projectile) {
                Player shooter;
                Projectile projectile = (Projectile)attacker;
                deathString = this.getKillString(player.getName(), damageSource, attacker);
                if (this.isShotByPlayer(attacker) && (shooter = this.getPlayerShooter(projectile)) != null && shooter != player) {
                    gamePlayerData.addKill(shooter);
                    this.leaderboard.addStat(shooter, Leaderboard.Stats.KILLS);
                }
            } else {
                deathString = damageType == DamageType.MOB_ATTACK || damageType == DamageType.MOB_ATTACK_NO_AGGRO ? this.getKillString(player.getName(), damageSource, attacker) : this.getNaturalDeathString(damageSource, player);
            }
            gamePlayerData.messageAllActivePlayers(this.lang.death_messages_prefix + " <light_purple>" + deathString);
            this.leaderboard.addStat(player, Leaderboard.Stats.DEATHS);
            this.leaderboard.addStat(player, Leaderboard.Stats.GAMES);
            for (Player alive : game.getGamePlayerData().getPlayers()) {
                if (alive == null || player == alive) continue;
                alive.playSound(alive.getLocation(), Config.SOUNDS_DEATH, 5.0f, 1.0f);
            }
            gamePlayerData.leaveGame(player, true);
            game.getGameCommandData().runCommands(GameCommandData.CommandType.DEATH, player);
            PlayerDeathGameEvent event = new PlayerDeathGameEvent(player, damageSource, drops, deathString, game);
            event.callEvent();
            PlayerDeathEvent playerDeathEvent = new PlayerDeathEvent(player, damageSource, drops, 0, Util.getMini(deathString, new Object[0]));
            playerDeathEvent.callEvent();
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.checkStick(game), 40L);
        }, 1L);
    }

    private List<ItemStack> dropInventoryOfPlayer(Player player) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        PlayerInventory inventory = player.getInventory();
        Location location = player.getLocation();
        World world = player.getWorld();
        for (ItemStack itemStack : inventory.getStorageContents()) {
            if (itemStack == null || itemStack.getType() == Material.AIR || ItemUtils.isCursed(itemStack)) continue;
            drops.add(itemStack);
            world.dropItemNaturally(location, itemStack).setPersistent(false);
        }
        for (ItemStack itemStack : inventory.getArmorContents()) {
            if (itemStack == null || itemStack.getType() == Material.AIR || ItemUtils.isCursed(itemStack)) continue;
            drops.add(itemStack);
            world.dropItemNaturally(location, itemStack).setPersistent(false);
        }
        return drops;
    }

    private void checkStick(Game game) {
        if (Config.PLAYERS_FOR_TRACKING_STICK == game.getGamePlayerData().getPlayers().size()) {
            for (Player player : game.getGamePlayerData().getPlayers()) {
                Util.sendMessage((CommandSender)player, this.lang.tracking_stick_bar, new Object[0]);
                Util.sendMessage((CommandSender)player, this.lang.tracking_stick_new1, new Object[0]);
                Util.sendMessage((CommandSender)player, this.lang.tracking_stick_new2, new Object[0]);
                Util.sendMessage((CommandSender)player, this.lang.tracking_stick_bar, new Object[0]);
                player.getInventory().addItem(new ItemStack[]{ItemUtils.getTrackingStick()});
            }
        }
    }
}

