/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.managers;

import com.shanebeestudios.hg.api.data.MobData;
import com.shanebeestudios.hg.api.data.MobEntry;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.parsers.ItemParser;
import com.shanebeestudios.hg.api.registry.Registries;
import com.shanebeestudios.hg.api.util.NBTApi;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.configs.Config;
import io.lumine.mythic.api.mobs.MythicMob;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.Nullable;

public class MobManager {
    private final HungerGames plugin;
    private final Random random = new Random();
    private MobData defaultMobData;

    public MobManager(HungerGames plugin) {
        this.plugin = plugin;
        this.loadDefaultMobs();
    }

    private void loadDefaultMobs() {
        Util.log("Loading mobs:", new Object[0]);
        File kitFile = new File(this.plugin.getDataFolder(), "mobs.yml");
        if (!kitFile.exists()) {
            this.plugin.saveResource("mobs.yml", false);
            Util.log("- New mobs.yml file has been <green>successfully generated!", new Object[0]);
        }
        YamlConfiguration mobConfig = YamlConfiguration.loadConfiguration((File)kitFile);
        ConfigurationSection mobsSection = mobConfig.getConfigurationSection("mobs");
        assert (mobsSection != null);
        this.defaultMobData = this.createMobData(mobsSection, null);
        Util.log("- <aqua>%s <grey>mobs have been <green>successfully loaded!", this.defaultMobData.getMobCount());
    }

    public MobData getDefaultMobData() {
        return this.defaultMobData;
    }

    public void loadGameMobs(Game game, ConfigurationSection arenaConfig) {
        ConfigurationSection mobsSection = arenaConfig.getConfigurationSection("mobs");
        if (mobsSection == null) {
            return;
        }
        MobData mobData = this.createMobData(mobsSection, game);
        Util.log("- Loaded <aqua>%s <grey>custom mobs for arena <white>'<aqua>%s<white>'", mobData.getMobCount(), game.getGameArenaData().getName());
        game.getGameEntityData().setMobData(mobData);
    }

    /*
     * Unable to fully structure code
     */
    private MobData createMobData(ConfigurationSection mobsSection, @Nullable Game game) {
        mobData = new MobData();
        count = 0;
        gameName = game != null ? game.getGameArenaData().getName() + ":" : "";
        for (String time : Arrays.asList(new String[]{"day", "night"})) {
            if (!mobsSection.contains(time)) continue;
            timeSection = mobsSection.getConfigurationSection(time);
            if (!MobManager.$assertionsDisabled && timeSection == null) {
                throw new AssertionError();
            }
            for (String sectionKey : timeSection.getKeys(false)) {
                mobEntryKey = gameName + time + ":" + sectionKey;
                mobSection = timeSection.getConfigurationSection(sectionKey);
                if (!MobManager.$assertionsDisabled && mobSection == null) {
                    throw new AssertionError();
                }
                typeString = mobSection.getString("type");
                if (typeString == null) continue;
                if (!typeString.startsWith("MM:")) ** GOTO lbl26
                if (this.plugin.getMythicMobManager() == null) continue;
                mythicMob = typeString.replace("MM:", "");
                level = mobSection.getDouble("level", 0.0);
                mob = this.plugin.getMythicMobManager().getMythicMob(mythicMob);
                if (mob.isPresent()) {
                    mobEntry = new MobEntry(mobEntryKey, (MythicMob)mob.get(), level);
                } else {
                    Util.warning("Invalid MythicMob: %s", new Object[]{mythicMob});
                    continue;
lbl26:
                    // 1 sources

                    namespacedKey = NamespacedKey.fromString((String)typeString);
                    if (namespacedKey == null) {
                        Util.log("<red>Invalid entity type <white>'<yellow>%s<white>'", new Object[]{typeString});
                        continue;
                    }
                    entityType = (EntityType)Registries.ENTITY_TYPE_REGISTRY.get(namespacedKey);
                    if (entityType == null) {
                        Util.log("<red>Invalid entity type <white>'<yellow>%s<white>'", new Object[]{namespacedKey});
                        continue;
                    }
                    mobEntry = new MobEntry(mobEntryKey, entityType);
                    if (mobSection.contains("name")) {
                        name = mobSection.getString("name");
                        mobEntry.setName(Util.getMini(name, new Object[0]));
                    }
                    if ((gearSection = mobSection.getConfigurationSection("gear")) != null) {
                        for (EquipmentSlot slot : EquipmentSlot.values()) {
                            slotName = slot.name().toLowerCase(Locale.ROOT);
                            if (!gearSection.contains(slotName) || (itemStack = ItemParser.parseItem(itemSection = gearSection.getConfigurationSection(slotName))) == null) continue;
                            mobEntry.addGear(slot, itemStack);
                        }
                    }
                    if (mobSection.contains("potion_effects")) {
                        potionEffects = new ArrayList<PotionEffect>();
                        if (mobSection.isConfigurationSection("potion_effects")) {
                            potionEffectsSection = mobSection.getConfigurationSection("potion_effects");
                            if (!MobManager.$assertionsDisabled && potionEffectsSection == null) {
                                throw new AssertionError();
                            }
                            for (String key : potionEffectsSection.getKeys(false)) {
                                potionEffect = ItemParser.parsePotionEffect(key, potionEffectsSection);
                                potionEffects.add(potionEffect);
                            }
                        }
                        mobEntry.addPotionEffects(potionEffects);
                    }
                }
                if (mobSection.isConfigurationSection("attributes")) {
                    attributesSection = mobSection.getConfigurationSection("attributes");
                    if (!MobManager.$assertionsDisabled && attributesSection == null) {
                        throw new AssertionError();
                    }
                    for (String key : attributesSection.getKeys(false)) {
                        attributeKey = NamespacedKey.fromString((String)key);
                        if (attributeKey == null) {
                            Util.warning("Attribute key isn't valid '%s' for mob entry '%s:%s'", new Object[]{key, time, sectionKey});
                            continue;
                        }
                        attribute = (Attribute)Registries.ATTRIBUTE_REGISTRY.get(attributeKey);
                        if (attribute == null) {
                            Util.warning("Invalid attribute '%s' for mob entry '%s:%s'", new Object[]{attributeKey.toString(), time, sectionKey});
                            continue;
                        }
                        value = attributesSection.getDouble(key);
                        mobEntry.addAttribute(attribute, value);
                    }
                }
                if (mobSection.contains("nbt") && (nbtString = mobSection.getString("nbt")) != null) {
                    validated = NBTApi.validateNBT(nbtString);
                    if (validated != null) {
                        Util.warning("Invalid NBT '%s' for mob entry '%s:%s'", new Object[]{nbtString, time, sectionKey});
                    } else {
                        mobEntry.setNbt(nbtString);
                    }
                }
                if ((deathMessage = mobSection.getString("death_message", null)) != null) {
                    mobEntry.setDeathMessage(deathMessage);
                }
                weight = mobSection.getInt("weight", 1);
                ++count;
                for (i = 1; i <= weight; ++i) {
                    if (time.equalsIgnoreCase("day")) {
                        mobData.addDayMob(mobEntry);
                        continue;
                    }
                    mobData.addNightMob(mobEntry);
                }
                if (!Config.SETTINGS_DEBUG) continue;
                Util.log("- Loaded mob entry <white>'<aqua>%s<white>'", new Object[]{mobEntryKey});
            }
        }
        mobData.setMobCount(count);
        return mobData;
    }
}

