/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.managers;

import com.shanebeestudios.hg.api.data.Leaderboard;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.configs.Language;
import com.shanebeestudios.hg.plugin.managers.GameManager;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Placeholders
extends PlaceholderExpansion {
    private final HungerGames plugin;
    private final Leaderboard leaderboard;
    private final Language lang;

    public Placeholders(HungerGames plugin) {
        this.plugin = plugin;
        this.leaderboard = plugin.getLeaderboard();
        this.lang = plugin.getLang();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    @NotNull
    public String getIdentifier() {
        return "hungergames";
    }

    @NotNull
    public String getAuthor() {
        return this.plugin.getPluginMeta().getAuthors().toString();
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getPluginMeta().getVersion();
    }

    @Nullable
    public String onRequest(OfflinePlayer offlinePlayer, @NotNull String identifier) {
        GameManager gameManager = this.plugin.getGameManager();
        String[] id = identifier.split("_");
        switch (id[0]) {
            case "lb": {
                switch (id[1]) {
                    case "wins": 
                    case "kills": 
                    case "deaths": 
                    case "games": {
                        if (id[2].equalsIgnoreCase("p")) {
                            return this.getStatPlayers(identifier);
                        }
                        if (id[2].equalsIgnoreCase("s")) {
                            return this.getStatScores(identifier);
                        }
                        if (id[2].equalsIgnoreCase("c")) {
                            return this.getStatPlayers(identifier) + " : " + this.getStatScores(identifier);
                        }
                        if (!id[2].equalsIgnoreCase("player")) break;
                        return this.getStatsPlayer(identifier, offlinePlayer);
                    }
                }
            }
            case "status": {
                return gameManager.getGame(id[1]).getGameArenaData().getStatus().getStringName();
            }
            case "player_status": {
                if (offlinePlayer instanceof Player) {
                    Player player = (Player)offlinePlayer;
                    return this.plugin.getPlayerManager().getPlayerStatus(player).getStringName();
                }
            }
            case "cost": {
                return String.valueOf(gameManager.getGame(id[1]).getGameArenaData().getCost());
            }
            case "playerscurrent": {
                return String.valueOf(gameManager.getGame(id[1]).getGamePlayerData().getPlayers().size());
            }
            case "playersmax": {
                return String.valueOf(gameManager.getGame(id[1]).getGameArenaData().getMaxPlayers());
            }
            case "playersmin": {
                return String.valueOf(gameManager.getGame(id[1]).getGameArenaData().getMinPlayers());
            }
        }
        return null;
    }

    private String getStatsPlayer(String identifier, OfflinePlayer player) {
        String[] ind = identifier.split("_");
        Leaderboard.Stats stat = Leaderboard.Stats.valueOf(ind[1].toUpperCase());
        return String.valueOf(this.leaderboard.getStat(player.getUniqueId(), stat));
    }

    private String getStatPlayers(String identifier) {
        String[] ind = identifier.split("_");
        Leaderboard.Stats stat = Leaderboard.Stats.valueOf(ind[1].toUpperCase());
        int leader = Integer.parseInt(ind[3]);
        if (this.leaderboard.getStatsPlayers(stat).size() >= leader) {
            return this.leaderboard.getStatsPlayers(stat).get(leader - 1);
        }
        return this.lang.leaderboard_blank_space;
    }

    private String getStatScores(String identifier) {
        String[] ind = identifier.split("_");
        Leaderboard.Stats stat = Leaderboard.Stats.valueOf(ind[1].toUpperCase());
        int leader = Integer.parseInt(ind[3]);
        if (this.leaderboard.getStatsScores(stat).size() >= leader) {
            return this.leaderboard.getStatsScores(stat).get(leader - 1);
        }
        return this.lang.leaderboard_blank_space;
    }
}

