/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.managers;

import com.shanebeestudios.hg.api.data.PlayerData;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.status.PlayerStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class PlayerManager {
    private final Map<UUID, PlayerData> playerMap = new HashMap<UUID, PlayerData>();
    private final Map<UUID, PlayerData> spectatorMap = new HashMap<UUID, PlayerData>();

    public boolean hasPlayerData(Player player) {
        return this.hasPlayerData(player.getUniqueId());
    }

    public boolean hasPlayerData(UUID uuid) {
        return this.playerMap.containsKey(uuid);
    }

    public boolean hasSpectatorData(Player player) {
        return this.hasSpectatorData(player.getUniqueId());
    }

    public boolean hasSpectatorData(UUID uuid) {
        return this.spectatorMap.containsKey(uuid);
    }

    @Nullable
    public PlayerData getPlayerData(Player player) {
        return this.getPlayerData(player.getUniqueId());
    }

    @Nullable
    public PlayerData getPlayerData(UUID uuid) {
        if (this.hasPlayerData(uuid)) {
            return this.playerMap.get(uuid);
        }
        return null;
    }

    @Nullable
    public PlayerData getSpectatorData(Player player) {
        return this.getSpectatorData(player.getUniqueId());
    }

    @Nullable
    public PlayerData getSpectatorData(UUID uuid) {
        if (this.hasSpectatorData(uuid)) {
            return this.spectatorMap.get(uuid);
        }
        return null;
    }

    @Nullable
    public PlayerData getData(Player player) {
        return this.getData(player.getUniqueId());
    }

    @Nullable
    public PlayerData getData(UUID uuid) {
        if (this.hasPlayerData(uuid)) {
            return this.getPlayerData(uuid);
        }
        if (this.hasSpectatorData(uuid)) {
            return this.getSpectatorData(uuid);
        }
        return null;
    }

    public boolean hasData(Player player) {
        return this.hasData(player.getUniqueId());
    }

    public boolean hasData(UUID uuid) {
        return this.hasPlayerData(uuid) || this.hasSpectatorData(uuid);
    }

    public void addPlayerData(PlayerData playerData) {
        this.playerMap.put(playerData.getUuid(), playerData);
    }

    public void addSpectatorData(PlayerData playerData) {
        this.spectatorMap.put(playerData.getUuid(), playerData);
    }

    public void removePlayerData(Player player) {
        this.playerMap.remove(player.getUniqueId());
    }

    public void removePlayerData(UUID uuid) {
        this.playerMap.remove(uuid);
    }

    public void removeSpectatorData(Player player) {
        this.spectatorMap.remove(player.getUniqueId());
    }

    public void removeSpectatorData(UUID uuid) {
        this.spectatorMap.remove(uuid);
    }

    public boolean transferPlayerDataToSpectator(Player player) {
        return this.transferPlayerDataToSpectator(player.getUniqueId());
    }

    public boolean transferPlayerDataToSpectator(UUID uuid) {
        PlayerData clone;
        if (this.playerMap.containsKey(uuid) && (clone = this.playerMap.get(uuid).clone()) != null) {
            this.spectatorMap.put(uuid, clone);
            this.playerMap.remove(uuid);
            return true;
        }
        return false;
    }

    @Nullable
    public Game getGame(Player player) {
        return this.getGame(player.getUniqueId());
    }

    @Nullable
    public Game getGame(UUID uuid) {
        if (this.hasPlayerData(uuid)) {
            return this.getPlayerData(uuid).getGame();
        }
        if (this.hasSpectatorData(uuid)) {
            return this.getSpectatorData(uuid).getGame();
        }
        return null;
    }

    public boolean isInGame(Player player) {
        return this.getGame(player) != null;
    }

    public PlayerStatus getPlayerStatus(Player player) {
        if (this.hasPlayerData(player)) {
            return PlayerStatus.IN_GAME;
        }
        if (this.hasSpectatorData(player)) {
            return PlayerStatus.SPECTATOR;
        }
        return PlayerStatus.NOT_IN_GAME;
    }
}

