/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.permission;

import com.shanebeestudios.hg.api.util.Util;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.util.permissions.DefaultPermissions;
import org.jetbrains.annotations.Nullable;

public class Permissions {
    static final Map<String, org.bukkit.permissions.Permission> PERMISSIONS = new LinkedHashMap<String, org.bukkit.permissions.Permission>();
    public static final Permission COMMAND_CREATE = Permissions.getCommand("create", "Create a new game arena", PermissionDefault.OP);
    public static final Permission COMMAND_DEBUG = Permissions.getCommand("debug", "Debug an arena", PermissionDefault.OP);
    public static final Permission COMMAND_DELETE = Permissions.getCommand("delete", "Delete a game arena", PermissionDefault.OP);
    public static final Permission COMMAND_EDIT = Permissions.getCommand("edit", "Edit a game arena", PermissionDefault.OP);
    public static final Permission COMMAND_FORCE_START = Permissions.getCommand("forcestart", "Force start a game arena", PermissionDefault.OP);
    public static final Permission COMMAND_JOIN = Permissions.getCommand("join", "Join a game", PermissionDefault.TRUE);
    public static final Permission COMMAND_JOIN_OTHERS = Permissions.getCommand("join_others", "Join other players to a game", PermissionDefault.OP);
    public static final Permission COMMAND_KIT = Permissions.getCommand("kit", "Get a kit in a game", PermissionDefault.TRUE);
    public static final Permission COMMAND_LEAVE = Permissions.getCommand("leave", "Leave a game", PermissionDefault.TRUE);
    public static final Permission COMMAND_LIST = Permissions.getCommand("list", "List all players in your game", PermissionDefault.TRUE);
    public static final Permission COMMAND_NBT = Permissions.getCommand("nbt", "Get the NBT of an item from the configs", PermissionDefault.OP);
    public static final Permission COMMAND_PERMISSIONS = Permissions.getCommand("permissions", "List of permissions", PermissionDefault.OP);
    public static final Permission COMMAND_REFILL_CHESTS = Permissions.getCommand("refill_chests", "Refill chests in a game", PermissionDefault.OP);
    public static final Permission COMMAND_RELOAD = Permissions.getCommand("reload", "Reload configs/arenas", PermissionDefault.OP);
    public static final Permission COMMAND_SET_EXIT = Permissions.getCommand("setexit", "Set the exit of a game, all games or the global exit", PermissionDefault.OP);
    public static final Permission COMMAND_SETTINGS = Permissions.getCommand("settings", "Temporarily modify some config settings (not saved to file)", PermissionDefault.OP);
    public static final Permission COMMAND_SPECTATE = Permissions.getCommand("spectate", "Spectate a game", PermissionDefault.TRUE);
    public static final Permission COMMAND_STATUS = Permissions.getCommand("status", "Show status of a game", PermissionDefault.TRUE);
    public static final Permission COMMAND_STOP = Permissions.getCommand("stop", "Stop the game", PermissionDefault.OP);
    public static final Permission COMMAND_STOP_ALL = Permissions.getCommand("stopallgames", "Stop all games", PermissionDefault.OP);
    public static final Permission COMMAND_TEAM = Permissions.getCommand("team", "Create/join teams in a game", PermissionDefault.TRUE);
    public static final Permission COMMAND_TEAM_TELEPORT = Permissions.getCommand("team.teleport", "Teleport to a team member", PermissionDefault.TRUE);
    public static final Permission COMMAND_TOGGLE = Permissions.getCommand("toggle", "Toggle a game", PermissionDefault.OP);
    public static final Permission BYPASS_COMMAND_RESTRICTION = Permissions.getBase("bypass.command.restriction", "Bypass command restriction while in games", PermissionDefault.OP);

    private static Permission getCommand(String perm, String description, PermissionDefault defaultPermission) {
        return Permissions.getBase("command." + perm, description, defaultPermission);
    }

    public static Permission registerKitPermission(@Nullable String arenaName, String kitName, String kitPermission) {
        String message;
        if (arenaName != null) {
            message = "Permission for kit '" + kitName + "' in arena '" + arenaName + "'";
        } else {
            arenaName = "kits";
            message = "Permission for kit '" + kitName + "' in kits.yml";
        }
        return Permissions.getBase("kit." + arenaName + "." + kitPermission, message, PermissionDefault.OP);
    }

    private static Permission getBase(String perm, String description, PermissionDefault defaultPermission) {
        String stringPerm = "hungergames." + perm;
        org.bukkit.permissions.Permission bukkitPermission = DefaultPermissions.registerPermission((String)stringPerm, (String)description, (PermissionDefault)defaultPermission);
        PERMISSIONS.put(stringPerm, bukkitPermission);
        return new Permission(stringPerm, bukkitPermission);
    }

    public static void debug() {
        Util.log("Permissions:", new Object[0]);
        for (Map.Entry<String, org.bukkit.permissions.Permission> entry : PERMISSIONS.entrySet()) {
            String color = switch (entry.getValue().getDefault()) {
                default -> throw new MatchException(null, null);
                case PermissionDefault.OP -> "yellow";
                case PermissionDefault.TRUE, PermissionDefault.NOT_OP -> "green";
                case PermissionDefault.FALSE -> "red";
            };
            Util.log("  <white>'<#F09616>%s<white>':", entry.getKey());
            Util.log("    <grey> Description: <aqua>%s", entry.getValue().getDescription());
            Util.log("    <grey> Default: <%s>%s", color, entry.getValue().getDefault().toString());
        }
    }

    public record Permission(String permission, org.bukkit.permissions.Permission bukkitPermission) {
        public boolean has(CommandSender sender) {
            return sender.hasPermission(this.bukkitPermission.getName());
        }
    }
}

