/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.tasks;

import com.shanebeestudios.hg.api.util.Constants;
import com.shanebeestudios.hg.plugin.HungerGames;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.BlockType;
import org.bukkit.block.TileState;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ChestDropChestTask
implements Runnable {
    private final Location startLocation;
    private BlockDisplay display;
    private final int taskId;

    public ChestDropChestTask(Location location) {
        this.startLocation = location.clone().add(0.0, 20.0, 0.0);
        this.startLocation.setYaw(180.0f);
        this.startLocation.setPitch(0.0f);
        this.display = (BlockDisplay)location.getWorld().spawn(this.startLocation, BlockDisplay.class, blockDisplay -> {
            blockDisplay.setBlock(BlockType.CHEST.createBlockData(chest -> chest.setFacing(BlockFace.NORTH)));
            blockDisplay.setTeleportDuration(2);
        });
        this.taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)HungerGames.getPlugin(), (Runnable)this, 2L, 2L);
    }

    @Override
    public void run() {
        if (this.startLocation.getBlock().getRelative(BlockFace.DOWN).isSolid()) {
            this.startLocation.add(-1.0, 0.0, -1.0);
            this.startLocation.getBlock().setBlockData(this.display.getBlock());
            BlockState blockState = this.startLocation.getBlock().getState();
            if (blockState instanceof TileState) {
                TileState state = (TileState)blockState;
                PersistentDataContainer pdc = state.getPersistentDataContainer();
                pdc.set(Constants.CHEST_DROP_BLOCK, PersistentDataType.BOOLEAN, (Object)true);
                state.update();
            }
            this.stop();
        } else {
            this.startLocation.add(0.0, -1.0, 0.0);
            this.display.teleport(this.startLocation);
        }
    }

    public void stop() {
        if (this.display != null && this.display.isValid()) {
            this.display.remove();
        }
        this.display = null;
        Bukkit.getScheduler().cancelTask(this.taskId);
    }
}

