/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.tasks;

import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameRegion;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.configs.Config;
import com.shanebeestudios.hg.plugin.configs.Language;
import com.shanebeestudios.hg.plugin.tasks.ChestDropChestTask;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ChestDropTask
implements Runnable {
    private final Game game;
    private final Language lang;
    private final int taskId;
    private final List<ChestDropChestTask> tasks = new ArrayList<ChestDropChestTask>();

    public ChestDropTask(Game game) {
        this.game = game;
        HungerGames plugin = HungerGames.getPlugin();
        this.lang = plugin.getLang();
        int interval = Config.CHESTS_CHEST_DROP_INTERVAL * 20;
        this.taskId = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, (Runnable)this, (long)interval, (long)interval);
    }

    @Override
    public void run() {
        GameRegion gameRegion = this.game.getGameArenaData().getGameRegion();
        Location randomLocation = gameRegion.getRandomLocation();
        for (Player player : this.game.getGamePlayerData().getPlayers()) {
            Util.sendMessage((CommandSender)player, this.lang.chest_drop_1, new Object[0]);
            Util.sendMessage((CommandSender)player, this.lang.chest_drop_2.replace("<x>", "" + randomLocation.getBlockX()).replace("<y>", "" + randomLocation.getBlockY()).replace("<z>", "" + randomLocation.getBlockZ()), new Object[0]);
            Util.sendMessage((CommandSender)player, this.lang.chest_drop_1, new Object[0]);
            this.tasks.add(new ChestDropChestTask(randomLocation));
        }
    }

    public void stop() {
        this.tasks.forEach(ChestDropChestTask::stop);
        this.tasks.clear();
        Bukkit.getScheduler().cancelTask(this.taskId);
    }
}

