/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.tasks;

import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.configs.Config;
import com.shanebeestudios.hg.plugin.configs.Language;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class StartingTask
implements Runnable {
    private int timer = 30;
    private final int taskId;
    private final Game game;
    private final Language lang;

    public StartingTask(Game game) {
        this.game = game;
        this.lang = game.getPlugin().getLang();
        String name = game.getGameArenaData().getName();
        String broadcast = this.lang.game_countdown_started.replace("<arena>", name).replace("<seconds>", "" + this.timer);
        if (Config.BROADCAST_JOIN_MESSAGES) {
            Util.broadcast(broadcast);
            Util.broadcast(this.lang.game_join.replace("<arena>", name));
        } else {
            this.game.getGamePlayerData().messageAllActivePlayers(broadcast);
        }
        this.taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)game.getPlugin(), (Runnable)this, 100L, 100L);
    }

    @Override
    public void run() {
        this.timer -= 5;
        if (this.timer <= 0) {
            this.stop();
            this.game.startFreeRoam();
        } else {
            this.game.getGamePlayerData().messageAllActivePlayers(this.lang.game_countdown_timer.replace("<timer>", String.valueOf(this.timer)));
        }
    }

    public void stop() {
        Bukkit.getScheduler().cancelTask(this.taskId);
    }
}

