/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.command;

import com.shanebeestudios.hg.api.data.PlayerData;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameTeam;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.configs.Language;
import com.shanebeestudios.hg.plugin.managers.GameManager;
import com.shanebeestudios.hg.plugin.managers.PlayerManager;
import com.shanebeestudios.hg.shaded-api.commandapi.arguments.Argument;
import com.shanebeestudios.hg.shaded-api.commandapi.arguments.ArgumentSuggestions;
import com.shanebeestudios.hg.shaded-api.commandapi.arguments.CustomArgument;
import com.shanebeestudios.hg.shaded-api.commandapi.arguments.EntitySelectorArgument;
import com.shanebeestudios.hg.shaded-api.commandapi.arguments.StringArgument;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;

public abstract class CustomArg {
    private static Language LANG;
    private static GameManager GAME_MANAGER;
    private static PlayerManager PLAYER_MANAGER;
    public static final CustomArg GAME;
    public static final CustomArg GAME_PLAYER_FOR_TEAM;
    public static final CustomArg GAME_PLAYER_ON_TEAM;

    @ApiStatus.Internal
    public static void init(HungerGames plugin, GameManager gameManager) {
        LANG = plugin.getLang();
        GAME_MANAGER = gameManager;
        PLAYER_MANAGER = plugin.getPlayerManager();
    }

    public abstract Argument<?> get(String var1);

    static {
        GAME = new CustomArg(){

            @Override
            public Argument<?> get(String name) {
                return (Argument)new CustomArgument<Game, String>(new StringArgument(name), info -> {
                    String gameName = info.input().toLowerCase(Locale.ROOT);
                    Game game = GAME_MANAGER.getGame(gameName);
                    if (game == null) {
                        String msg = CustomArg.LANG.command_base_invalid_game.replace("<arena>", gameName);
                        Util.throwCustomArgException(msg);
                    }
                    return game;
                }).includeSuggestions(ArgumentSuggestions.stringCollectionAsync(info -> CompletableFuture.supplyAsync(GAME_MANAGER::getGameNames)));
            }
        };
        GAME_PLAYER_FOR_TEAM = new CustomArg(){

            @Override
            public Argument<?> get(String name) {
                return (Argument)new CustomArgument<Player, Player>(new EntitySelectorArgument.OnePlayer(name), info -> {
                    Player player = (Player)info.currentInput();
                    if (PLAYER_MANAGER.getGame(player) == null) {
                        String msg = CustomArg.LANG.command_team_player_not_available.replace("<player>", player.getName());
                        Util.throwCustomArgException(msg);
                    }
                    return player;
                }).replaceSuggestions(ArgumentSuggestions.stringCollectionAsync(info -> {
                    Object patt0$temp = info.sender();
                    if (!(patt0$temp instanceof Player)) {
                        return null;
                    }
                    Player player = (Player)patt0$temp;
                    PlayerData playerData = PLAYER_MANAGER.getPlayerData(player);
                    if (playerData == null) {
                        return null;
                    }
                    Game game = playerData.getGame();
                    if (game == null) {
                        return null;
                    }
                    GameTeam gameTeam = game.getGameScoreboard().getGameTeam(player);
                    if (gameTeam == null) {
                        return null;
                    }
                    if (gameTeam.getLeader() != player) {
                        return null;
                    }
                    List<String> names = game.getGamePlayerData().getPlayers().stream().filter(p -> !gameTeam.isOnTeam((Player)p) && !gameTeam.isPending((Player)p)).map(Player::getName).toList();
                    return CompletableFuture.supplyAsync(() -> names);
                }));
            }
        };
        GAME_PLAYER_ON_TEAM = new CustomArg(){

            @Override
            public Argument<?> get(String name) {
                return (Argument)new CustomArgument<Player, Player>(new EntitySelectorArgument.OnePlayer(name), info -> {
                    Player player = (Player)info.currentInput();
                    if (PLAYER_MANAGER.getGame(player) == null) {
                        String msg = CustomArg.LANG.command_team_player_not_available.replace("<player>", player.getName());
                        Util.throwCustomArgException(msg);
                    }
                    return player;
                }).replaceSuggestions(ArgumentSuggestions.stringCollectionAsync(info -> {
                    Object patt0$temp = info.sender();
                    if (!(patt0$temp instanceof Player)) {
                        return null;
                    }
                    Player player = (Player)patt0$temp;
                    PlayerData playerData = PLAYER_MANAGER.getPlayerData(player);
                    if (playerData == null) {
                        return null;
                    }
                    Game game = playerData.getGame();
                    if (game == null) {
                        return null;
                    }
                    GameTeam gameTeam = game.getGameScoreboard().getGameTeam(player);
                    if (gameTeam == null) {
                        return null;
                    }
                    List<String> names = gameTeam.getPlayers().stream().filter(teamMember -> teamMember != player).map(Player::getName).toList();
                    return CompletableFuture.supplyAsync(() -> names);
                }));
            }
        };
    }
}

