/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.data;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Rotation;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.ItemStack;

public class ItemFrameData {
    private final Location location;
    private final BlockFace attachedFace;
    private final ItemStack itemStack;
    private final Rotation rotation;
    private final UUID uuid;

    public ItemFrameData(ItemFrame itemFrame) {
        this.location = itemFrame.getLocation();
        this.attachedFace = itemFrame.getAttachedFace();
        this.itemStack = itemFrame.getItem().clone();
        this.rotation = itemFrame.getRotation();
        this.uuid = itemFrame.getUniqueId();
    }

    public void resetItem() {
        World world = this.location.getWorld();
        if (world == null) {
            return;
        }
        Entity entity = Bukkit.getEntity((UUID)this.uuid);
        if (entity == null) {
            entity = world.spawn(this.location, ItemFrame.class, itemFrame -> itemFrame.setFacingDirection(this.attachedFace.getOppositeFace(), true));
        }
        if (entity instanceof ItemFrame) {
            ItemFrame itemFrame2 = (ItemFrame)entity;
            if (entity.isValid()) {
                itemFrame2.setItem(this.itemStack);
                itemFrame2.setRotation(this.rotation);
            }
        }
    }
}

