/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.data;

import com.google.common.collect.ImmutableMap;
import com.shanebeestudios.hg.api.data.KitEntry;
import com.shanebeestudios.hg.api.data.PlayerData;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.configs.Language;
import com.shanebeestudios.hg.plugin.managers.PlayerManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class KitData {
    private final PlayerManager playerManager = HungerGames.getPlugin().getPlayerManager();
    private final Language lang = HungerGames.getPlugin().getLang();
    private final Map<String, KitEntry> kitEntries = new HashMap<String, KitEntry>();
    private final Map<Player, KitEntry> preselectedKits = new HashMap<Player, KitEntry>();

    public boolean hasKitPermission(Player player, String kitName) {
        KitEntry kitEntry = this.kitEntries.get(kitName);
        return kitEntry == null || kitEntry.hasKitPermission(player);
    }

    public void givePreselectedOrDefaultKit(Player player) {
        if (this.preselectedKits.containsKey(player)) {
            KitEntry kitEntry = this.preselectedKits.get(player);
            this.preselectedKits.remove(player);
            kitEntry.setInventoryContent(player);
        } else if (this.kitEntries.containsKey("default")) {
            this.setKit(player, this.kitEntries.get("default"));
            Util.sendPrefixedMessage((CommandSender)player, this.lang.kits_give_default, new Object[0]);
        }
    }

    public void setKit(Player player, KitEntry kitEntry) {
        PlayerData playerData = this.playerManager.getPlayerData(player);
        if (playerData == null) {
            return;
        }
        if (playerData.hasGameStared()) {
            kitEntry.setInventoryContent(player);
            this.preselectedKits.remove(player);
        } else {
            this.preselectedKits.put(player, kitEntry);
            Util.sendPrefixedMessage((CommandSender)player, this.lang.kits_kit_gui_pre_select.replace("<kit>", kitEntry.getName()), new Object[0]);
        }
    }

    public String getKitListString(Player player) {
        if (!this.kitEntries.isEmpty()) {
            StringJoiner joiner = new StringJoiner(", ");
            this.kitEntries.forEach((kitName, kitEntry) -> {
                if (kitEntry.hasKitPermission(player)) {
                    joiner.add((CharSequence)kitName);
                }
            });
            return joiner.toString();
        }
        return null;
    }

    public List<String> getKitNameList(@Nullable Player player) {
        ArrayList<String> names = new ArrayList<String>();
        this.kitEntries.forEach((kitName, kitEntry) -> {
            if (player == null || kitEntry.hasKitPermission(player)) {
                names.add((String)kitName);
            }
        });
        return names;
    }

    public ImmutableMap<String, KitEntry> getKitEntries() {
        return ImmutableMap.copyOf(this.kitEntries);
    }

    public KitEntry getKitEntry(String kitName) {
        return this.kitEntries.get(kitName);
    }

    public boolean hasKits() {
        return !this.kitEntries.isEmpty();
    }

    public void addKitEntry(String name, KitEntry kit) {
        this.kitEntries.put(name, kit);
    }

    public void removeKitEntry(String name) {
        this.kitEntries.remove(name);
    }

    public void clearKits() {
        this.kitEntries.clear();
    }

    public void clearPreselectedKits() {
        this.preselectedKits.clear();
    }
}

