/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.data;

import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.permission.Permissions;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.Nullable;

public class KitEntry {
    private final String name;
    private Permissions.Permission permission = null;
    private ItemStack helmet = null;
    private ItemStack chestplate = null;
    private ItemStack leggings = null;
    private ItemStack boots = null;
    private List<ItemStack> inventoryContents = null;
    private List<PotionEffect> potionEffects = null;

    public KitEntry(String name) {
        this.name = name;
    }

    public KitEntry(@Nullable Game game, String name, List<ItemStack> inventoryContents, ItemStack helmet, ItemStack chestplate, ItemStack leggings, ItemStack boots, @Nullable String permission, List<PotionEffect> potionEffects) {
        this.name = name;
        this.inventoryContents = inventoryContents;
        this.helmet = helmet;
        this.chestplate = chestplate;
        this.leggings = leggings;
        this.boots = boots;
        this.potionEffects = potionEffects;
        if (permission != null && !permission.isEmpty()) {
            String arenaName = game != null ? game.getGameArenaData().getName() : null;
            this.permission = Permissions.registerKitPermission(arenaName, name, permission);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean hasKitPermission(Player player) {
        return this.permission == null || this.permission.has((CommandSender)player);
    }

    public void setHelmet(ItemStack helmet) {
        this.helmet = helmet;
    }

    public ItemStack getHelmet() {
        return this.helmet;
    }

    public void setChestplate(ItemStack chestplate) {
        this.chestplate = chestplate;
    }

    public ItemStack getChestplate() {
        return this.chestplate;
    }

    public void setLeggings(ItemStack leggings) {
        this.leggings = leggings;
    }

    public ItemStack getLeggings() {
        return this.leggings;
    }

    public void setBoots(ItemStack boots) {
        this.boots = boots;
    }

    public ItemStack getBoots() {
        return this.boots;
    }

    public void setPotionEffects(List<PotionEffect> potionEffects) {
        this.potionEffects = potionEffects;
    }

    public void addPotionEffect(PotionEffect potion) {
        this.potionEffects.add(potion);
    }

    public List<PotionEffect> getPotionEffects() {
        return this.potionEffects;
    }

    public void setPermission(@Nullable String arenaName, String permission) {
        this.permission = Permissions.registerKitPermission(arenaName, this.name, permission);
    }

    public Permissions.Permission getPermission() {
        return this.permission;
    }

    public void setInventoryContents(List<ItemStack> items) {
        this.inventoryContents = items;
    }

    public List<ItemStack> getInventoryContents() {
        return this.inventoryContents;
    }

    public void setInventoryContent(Player player) {
        Util.clearInv(player);
        player.getInventory().setContents(this.inventoryContents.toArray(new ItemStack[0]));
        player.getInventory().setHelmet(this.helmet);
        player.getInventory().setChestplate(this.chestplate);
        player.getInventory().setLeggings(this.leggings);
        player.getInventory().setBoots(this.boots);
        player.clearActivePotionEffects();
        player.addPotionEffects(this.potionEffects);
        player.updateInventory();
    }

    public String toString() {
        return "KitEntry{perm='" + String.valueOf(this.permission) + "', helmet=" + String.valueOf(this.helmet) + ", chestplate=" + String.valueOf(this.chestplate) + ", leggings=" + String.valueOf(this.leggings) + ", boots=" + String.valueOf(this.boots) + ", inventoryContents=" + String.valueOf(this.inventoryContents) + ", potions=" + String.valueOf(this.potionEffects) + "}";
    }
}

