/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.data;

import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Leaderboard {
    private final HungerGames plugin;
    private FileConfiguration leaderboardConfig;
    private File config_file;
    private final Map<Stats, Map<String, Data>> stats = new HashMap<Stats, Map<String, Data>>();

    public Leaderboard(HungerGames plugin) {
        this.plugin = plugin;
        for (Stats value : Stats.values()) {
            this.stats.put(value, new LinkedHashMap());
        }
        this.loadLeaderboard();
    }

    public void addStat(UUID uuid, Stats stat, int amount) {
        Map<String, Data> map = this.stats.get((Object)stat);
        Data data = map.getOrDefault(uuid.toString(), new Data(uuid));
        data.score += amount;
        map.put(uuid.toString(), data);
        this.sort(stat);
    }

    public void addStat(Player player, Stats stat) {
        this.addStat(player, stat, 1);
    }

    public void addStat(Player player, Stats stat, int amount) {
        this.addStat(player.getUniqueId(), stat, amount);
    }

    public int getStat(Player player, Stats stat) {
        return this.getStat(player.getUniqueId(), stat);
    }

    public int getStat(UUID uuid, Stats stat) {
        Map<String, Data> map = this.stats.get((Object)stat);
        if (map.containsKey(uuid.toString())) {
            return map.get((Object)uuid.toString()).score;
        }
        return 0;
    }

    public List<String> getStatsPlayers(Stats stat) {
        Map<String, Data> map = this.stats.get((Object)stat);
        ArrayList<String> playerNames = new ArrayList<String>();
        for (Map.Entry<String, Data> entry : map.entrySet()) {
            playerNames.add(entry.getValue().playerName);
        }
        return playerNames;
    }

    public List<Integer> getStatsScores(Stats stat) {
        Map<String, Data> map = this.stats.get((Object)stat);
        ArrayList<Integer> playerScores = new ArrayList<Integer>();
        for (Map.Entry<String, Data> entry : map.entrySet()) {
            playerScores.add(entry.getValue().score);
        }
        return playerScores;
    }

    public void saveLeaderboard() {
        for (Stats stat : Stats.values()) {
            ConfigurationSection statSection = this.leaderboardConfig.createSection(stat.getName());
            this.stats.get((Object)stat).forEach((key, value) -> statSection.set(key, (Object)value.score));
        }
        try {
            this.leaderboardConfig.save(this.config_file);
        }
        catch (IOException e) {
            Util.warning("Could not save leaderboard file: %s", e.getMessage());
        }
    }

    private void loadLeaderboard() {
        this.config_file = new File(this.plugin.getDataFolder(), "leaderboard.yml");
        if (!this.config_file.exists()) {
            this.plugin.saveResource("leaderboard.yml", true);
        }
        this.leaderboardConfig = YamlConfiguration.loadConfiguration((File)this.config_file);
        for (Stats stat : Stats.values()) {
            ConfigurationSection statSection = this.leaderboardConfig.getConfigurationSection(stat.getName());
            if (statSection == null) continue;
            HashMap<String, Data> map = new HashMap<String, Data>();
            for (String key : statSection.getKeys(false)) {
                UUID uuid = UUID.fromString(key);
                Data data = new Data(uuid);
                data.score = statSection.getInt(key);
                map.put(key, data);
            }
            this.stats.put(stat, map);
            this.sort(stat);
        }
    }

    private void sort(Stats stat) {
        LinkedHashMap collect = this.stats.get((Object)stat).entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        this.stats.put(stat, collect);
    }

    public static enum Stats {
        WINS("wins"),
        KILLS("kills"),
        DEATHS("deaths"),
        GAMES("games");

        private final String stat;

        private Stats(String stat) {
            this.stat = stat;
        }

        public String getName() {
            return this.stat;
        }
    }

    private static class Data
    implements Comparable<Data> {
        private final String playerName;
        private int score;

        public Data(UUID uuid) {
            this.playerName = Bukkit.getOfflinePlayer((UUID)uuid).getName();
        }

        @Override
        public int compareTo(@NotNull Data data) {
            return data.score - this.score;
        }
    }
}

