/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.data;

import com.google.common.collect.ImmutableList;
import com.shanebeestudios.hg.api.data.MobEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class MobData {
    private final Random random = new Random();
    private final List<MobEntry> dayMobs = new ArrayList<MobEntry>();
    private final List<MobEntry> nightMobs = new ArrayList<MobEntry>();
    private int mobCount;

    public List<MobEntry> getDayMobs() {
        return ImmutableList.copyOf(this.dayMobs);
    }

    @Nullable
    public MobEntry getRandomDayMob() {
        if (this.dayMobs.isEmpty()) {
            return null;
        }
        return this.dayMobs.get(this.random.nextInt(this.dayMobs.size()));
    }

    public void addDayMob(MobEntry mobEntry) {
        this.dayMobs.add(mobEntry);
    }

    public List<MobEntry> getNightMobs() {
        return ImmutableList.copyOf(this.nightMobs);
    }

    @Nullable
    public MobEntry getRandomNightMob() {
        if (this.nightMobs.isEmpty()) {
            return null;
        }
        return this.nightMobs.get(this.random.nextInt(this.nightMobs.size()));
    }

    public void addNightMob(MobEntry mobEntry) {
        this.nightMobs.add(mobEntry);
    }

    @ApiStatus.Internal
    public void setMobCount(int mobCount) {
        this.mobCount = mobCount;
    }

    public int getMobCount() {
        return this.mobCount;
    }

    public List<MobEntry> getAllMobs() {
        ArrayList<MobEntry> mobs = new ArrayList<MobEntry>();
        mobs.addAll(this.dayMobs);
        mobs.addAll(this.nightMobs);
        return mobs;
    }
}

