/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.data;

import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.configs.Language;
import io.papermc.paper.datacomponent.DataComponentTypes;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.util.BoundingBox;

public class PlayerSession {
    private final Language lang = HungerGames.getPlugin().getLang();
    private Stage stage = null;
    private final String name;
    private Block corner1;
    private Block corner2;
    private final int time;
    private final int minPlayers;
    private final int maxPlayers;
    private final int cost;
    private final List<Location> spawnLocations = new ArrayList<Location>();
    private Location signLocation;

    public PlayerSession(String name, int time, int minPlayers, int maxPlayers, int cost) {
        this.name = name;
        this.time = time;
        this.minPlayers = minPlayers;
        this.maxPlayers = maxPlayers;
        this.cost = cost;
    }

    public void start(Player player) {
        this.stage = Stage.CORNER_1;
        ItemStack itemStack = ItemType.STICK.createItemStack();
        itemStack.setData(DataComponentTypes.ITEM_NAME, (Object)Util.getMini(this.lang.command_create_session_stick_name, new Object[0]));
        player.getWorld().dropItem(player.getLocation(), itemStack);
        Util.sendPrefixedMessage((CommandSender)player, this.lang.command_create_session_start, new Object[0]);
    }

    public void click(Player player, Block block) {
        if (this.stage == Stage.CORNER_1) {
            this.corner1 = block;
            this.stage = Stage.CORNER_2;
            Util.sendPrefixedMessage((CommandSender)player, this.lang.command_create_session_next_corner, new Object[0]);
        } else if (this.stage == Stage.CORNER_2) {
            this.corner2 = block;
            if (this.isTooSmall()) {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_create_session_error_too_small, new Object[0]);
            } else if (this.isOverlapping()) {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_create_session_error_overlap, new Object[0]);
            } else {
                this.stage = Stage.SPAWN_LOCATIONS;
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_create_session_select_spawns, new Object[0]);
            }
        } else if (this.stage == Stage.SPAWN_LOCATIONS) {
            if (this.spawnLocations.size() >= this.maxPlayers) {
                this.stage = Stage.SIGN;
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_create_session_select_sign, new Object[0]);
            } else {
                double height = block.getBoundingBox().getHeight();
                Location location = block.getLocation().add(0.5, height, 0.5);
                location.setYaw(player.getLocation().getYaw());
                this.spawnLocations.add(location);
                if (this.spawnLocations.size() >= this.maxPlayers) {
                    this.stage = Stage.SIGN;
                    Util.sendPrefixedMessage((CommandSender)player, this.lang.command_create_session_select_sign, new Object[0]);
                } else {
                    int left = this.maxPlayers - this.spawnLocations.size();
                    Util.sendPrefixedMessage((CommandSender)player, this.lang.command_create_session_select_spawns_next.replace("<selected>", String.valueOf(this.spawnLocations.size())).replace("<left>", String.valueOf(left)), new Object[0]);
                }
            }
        } else if (this.stage == Stage.SIGN) {
            BlockState blockState = block.getState(false);
            if (blockState instanceof Sign) {
                Sign sign = (Sign)blockState;
                this.signLocation = sign.getLocation();
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_create_session_done, new Object[0]);
                this.finalizeGame(player);
            } else {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_create_session_sign_invalid, new Object[0]);
            }
        }
    }

    private void finalizeGame(Player player) {
        HungerGames plugin = HungerGames.getPlugin();
        plugin.getGameManager().createGame(this.name, this.corner1, this.corner2, this.spawnLocations, this.signLocation, this.time, this.minPlayers, this.maxPlayers, this.cost);
        plugin.getSessionManager().endPlayerSession(player);
    }

    private boolean isTooSmall() {
        if (this.corner1 == null || this.corner2 == null) {
            return true;
        }
        BoundingBox boundingBox = BoundingBox.of((Block)this.corner1, (Block)this.corner2);
        return boundingBox.getWidthX() <= 5.0 || boundingBox.getWidthZ() <= 5.0 || boundingBox.getHeight() <= 5.0;
    }

    private boolean isOverlapping() {
        if (this.corner1 == null || this.corner2 == null) {
            return true;
        }
        BoundingBox boundingBox = BoundingBox.of((Block)this.corner1, (Block)this.corner2);
        for (Game game : HungerGames.getPlugin().getGameManager().getGames()) {
            BoundingBox gameBox = game.getGameArenaData().getGameRegion().getBoundingBox();
            if (!boundingBox.overlaps(gameBox)) continue;
            return true;
        }
        return false;
    }

    private static enum Stage {
        CORNER_1,
        CORNER_2,
        SPAWN_LOCATIONS,
        SIGN;

    }
}

