/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.game;

import com.shanebeestudios.hg.api.data.Leaderboard;
import com.shanebeestudios.hg.api.data.PlayerData;
import com.shanebeestudios.hg.api.events.GameEndEvent;
import com.shanebeestudios.hg.api.events.GameStartEvent;
import com.shanebeestudios.hg.api.events.PlayerJoinGameEvent;
import com.shanebeestudios.hg.api.game.GameArenaData;
import com.shanebeestudios.hg.api.game.GameBarData;
import com.shanebeestudios.hg.api.game.GameBlockData;
import com.shanebeestudios.hg.api.game.GameBorderData;
import com.shanebeestudios.hg.api.game.GameCommandData;
import com.shanebeestudios.hg.api.game.GameEntityData;
import com.shanebeestudios.hg.api.game.GameItemData;
import com.shanebeestudios.hg.api.game.GamePlayerData;
import com.shanebeestudios.hg.api.game.GameRegion;
import com.shanebeestudios.hg.api.game.GameScoreboard;
import com.shanebeestudios.hg.api.game.GameTeam;
import com.shanebeestudios.hg.api.status.Status;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.api.util.Vault;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.configs.Config;
import com.shanebeestudios.hg.plugin.configs.Language;
import com.shanebeestudios.hg.plugin.managers.PlayerManager;
import com.shanebeestudios.hg.plugin.permission.Permissions;
import com.shanebeestudios.hg.plugin.tasks.ChestDropTask;
import com.shanebeestudios.hg.plugin.tasks.ChestRefillRepeatTask;
import com.shanebeestudios.hg.plugin.tasks.FreeRoamTask;
import com.shanebeestudios.hg.plugin.tasks.GameTimerTask;
import com.shanebeestudios.hg.plugin.tasks.MobSpawnerTask;
import com.shanebeestudios.hg.plugin.tasks.NearestPlayerCompassTask;
import com.shanebeestudios.hg.plugin.tasks.RollbackTask;
import com.shanebeestudios.hg.plugin.tasks.StartingTask;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class Game {
    final HungerGames plugin = HungerGames.getPlugin();
    final Language lang = this.plugin.getLang();
    private final PlayerManager playerManager;
    private MobSpawnerTask mobSpawnerTask;
    private FreeRoamTask freeRoamTask;
    private StartingTask startingTask;
    private GameTimerTask gameTimerTask;
    private ChestRefillRepeatTask chestRefillRepeatTask;
    private ChestDropTask chestDropTask;
    private NearestPlayerCompassTask nearestPlayerCompassTask;
    private final GameArenaData gameArenaData;
    private final GameEntityData gameEntityData;
    private final GameScoreboard gameScoreboard;
    private final GameBarData bar;
    private final GamePlayerData gamePlayerData;
    private final GameBlockData gameBlockData;
    private final GameItemData gameItemData;
    private final GameCommandData gameCommandData;
    private final GameBorderData gameBorderData;

    public Game(String name, GameRegion gameRegion, List<Location> spawns, Location lobbySign, int gameTimerTask, int minPlayers, int maxPlayers, int roam, boolean isReady, int cost) {
        this.gameArenaData = new GameArenaData(this, name, gameRegion, gameTimerTask, minPlayers, maxPlayers, roam, cost);
        this.gameEntityData = new GameEntityData(this);
        this.gamePlayerData = new GamePlayerData(this);
        this.gameBlockData = new GameBlockData(this);
        this.gameScoreboard = new GameScoreboard(this);
        this.playerManager = HungerGames.getPlugin().getPlayerManager();
        this.bar = new GameBarData(this);
        this.gameItemData = new GameItemData(this);
        this.gameCommandData = new GameCommandData(this);
        this.gameBorderData = new GameBorderData(this);
        this.gameArenaData.getSpawns().addAll(spawns);
        if (!this.gameBlockData.setLobbyBlock(lobbySign)) {
            isReady = false;
        }
        if (!this.plugin.getGameManager().checkGame(this, null)) {
            isReady = false;
        }
        this.gameArenaData.setStatus(isReady ? Status.READY : Status.BROKEN);
    }

    public GameArenaData getGameArenaData() {
        return this.gameArenaData;
    }

    public GameEntityData getGameEntityData() {
        return this.gameEntityData;
    }

    public GameScoreboard getGameScoreboard() {
        return this.gameScoreboard;
    }

    public GameBarData getGameBarData() {
        return this.bar;
    }

    public GamePlayerData getGamePlayerData() {
        return this.gamePlayerData;
    }

    public GameBlockData getGameBlockData() {
        return this.gameBlockData;
    }

    public GameItemData getGameItemData() {
        return this.gameItemData;
    }

    public GameCommandData getGameCommandData() {
        return this.gameCommandData;
    }

    public GameBorderData getGameBorderData() {
        return this.gameBorderData;
    }

    public StartingTask getStartingTask() {
        return this.startingTask;
    }

    public Location getLobbyLocation() {
        return this.gameBlockData.getSignLocation();
    }

    public HungerGames getPlugin() {
        return this.plugin;
    }

    public int getRemainingTime() {
        if (this.gameTimerTask != null) {
            return this.gameTimerTask.getRemainingTime();
        }
        return 0;
    }

    public void startWaitingPeriod() {
        this.gameArenaData.setStatus(Status.WAITING);
        long start = System.currentTimeMillis();
        int count = this.gameBlockData.logBlocksForRollback();
        this.gameBlockData.setupRandomizedBonusChests();
        long fin = System.currentTimeMillis() - start;
        if (Config.SETTINGS_DEBUG) {
            Util.log("Logged <aqua>%,d<grey> blocks in <aqua>%sms<grey> for arena <green>%s", count, fin, this.getGameArenaData().getName());
        }
    }

    public void startPreGameCountdown() {
        GameStartEvent event = new GameStartEvent(this);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.gameArenaData.setStatus(Status.COUNTDOWN);
        this.gamePlayerData.putAllPlayersIntoArena();
        this.startingTask = new StartingTask(this);
    }

    public void startFreeRoam() {
        this.gamePlayerData.getPlayers().forEach(HumanEntity::closeInventory);
        this.gameArenaData.setStatus(Status.FREE_ROAM);
        this.gameEntityData.removeEntities();
        this.freeRoamTask = new FreeRoamTask(this);
        this.gameCommandData.runCommands(GameCommandData.CommandType.START, null);
    }

    public void startRunningGame() {
        this.gameArenaData.setStatus(Status.RUNNING);
        if (Config.MOBS_SPAWN_ENABLED) {
            this.mobSpawnerTask = new MobSpawnerTask(this);
        }
        if (Config.CHESTS_CHEST_DROP_ENABLED) {
            this.chestDropTask = new ChestDropTask(this);
        }
        this.gameBlockData.updateLobbyBlock();
        if (Config.SETTINGS_BOSSBAR_COUNTDOWN) {
            this.bar.createBossBar(this.gameArenaData.getTimer());
        }
        if (Config.WORLD_BORDER_ENABLED) {
            this.gameBorderData.initialize();
        }
        this.gameTimerTask = new GameTimerTask(this, this.gameArenaData.getTimer());
        if (this.gameArenaData.getChestRefillRepeat() > 0) {
            this.chestRefillRepeatTask = new ChestRefillRepeatTask(this);
        }
        this.nearestPlayerCompassTask = new NearestPlayerCompassTask(this);
    }

    public void cancelTasks() {
        if (this.startingTask != null) {
            this.startingTask.stop();
        }
        if (this.freeRoamTask != null) {
            this.freeRoamTask.stop();
        }
        if (this.gameTimerTask != null) {
            this.gameTimerTask.stop();
        }
        if (this.mobSpawnerTask != null) {
            this.mobSpawnerTask.stop();
        }
        if (this.chestRefillRepeatTask != null) {
            this.chestRefillRepeatTask.stop();
        }
        if (this.chestDropTask != null) {
            this.chestDropTask.stop();
        }
        if (this.nearestPlayerCompassTask != null) {
            this.nearestPlayerCompassTask.stop();
        }
    }

    private void broadcastJoin(Player player) {
        if (!Config.SETTINGS_BROADCAST_JOIN_MESSAGES) {
            return;
        }
        String name = this.getGameArenaData().getName();
        Util.broadcast(this.lang.game_waiting_join.replace("<arena>", name).replace("<player>", player.getName()));
        int toStart = this.gameArenaData.getMinPlayers() - this.gamePlayerData.getPlayers().size();
        Util.broadcast(this.lang.game_waiting_players_to_start.replace("<amount>", "" + toStart));
        Util.broadcast(this.lang.game_join.replace("<arena>", name));
    }

    public boolean joinGame(Player player) {
        return this.joinGame(player, false);
    }

    public boolean joinGame(Player player, boolean savePreviousLocation) {
        if (this.gameArenaData.getStatus() == Status.BROKEN) {
            if (Permissions.COMMAND_CREATE.has((CommandSender)player)) {
                String name = this.gameArenaData.getName();
                Util.sendPrefixedMessage((CommandSender)player, this.lang.arena_debug_broken_debug.replace("<arena>", name), new Object[0]);
                Util.sendPrefixedMessage((CommandSender)player, this.lang.arena_debug_broken_debug_2.replace("<arena>", name), new Object[0]);
            }
            return false;
        }
        if (this.playerManager.isInGame(player)) {
            Util.sendPrefixedMessage((CommandSender)player, this.lang.command_join_already_in_game, new Object[0]);
            return false;
        }
        PlayerJoinGameEvent event = new PlayerJoinGameEvent(this, player);
        if (!event.callEvent()) {
            return false;
        }
        String arenaName = this.gameArenaData.getName();
        switch (this.gameArenaData.getStatus()) {
            case NOT_READY: 
            case ROLLBACK: 
            case STOPPED: 
            case BROKEN: {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.game_arena_not_ready, new Object[0]);
                return false;
            }
            case RUNNING: 
            case FREE_ROAM: {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.game_running.replace("<arena>", arenaName), arenaName);
                if (Config.SPECTATE_ENABLED) {
                    Util.sendPrefixedMessage((CommandSender)player, this.lang.game_arena_spectate.replace("<arena>", arenaName), new Object[0]);
                }
                return false;
            }
            case READY: {
                if (!this.canJoin(player)) {
                    return false;
                }
                this.gamePlayerData.addPlayerData(player, savePreviousLocation);
                this.startWaitingPeriod();
                this.broadcastJoin(player);
                Util.sendPrefixedMessage((CommandSender)player, this.lang.game_joined_waiting_to_teleport.replace("<arena>", arenaName), new Object[0]);
                break;
            }
            case WAITING: {
                if (!this.canJoin(player)) {
                    return false;
                }
                this.gamePlayerData.addPlayerData(player, savePreviousLocation);
                if (this.gamePlayerData.getPlayers().size() >= this.gameArenaData.getMinPlayers()) {
                    this.startPreGameCountdown();
                    break;
                }
                this.broadcastJoin(player);
                Util.sendPrefixedMessage((CommandSender)player, this.lang.game_joined_waiting_to_teleport.replace("<arena>", arenaName), new Object[0]);
                break;
            }
            case COUNTDOWN: {
                if (!this.canJoin(player)) {
                    return false;
                }
                this.gamePlayerData.addPlayerData(player, savePreviousLocation);
                this.gamePlayerData.putPlayerIntoArena(player);
            }
        }
        return true;
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean death) {
        if (Config.WORLD_BORDER_ENABLED) {
            this.gameBorderData.resetBorder();
        }
        this.gameEntityData.removeEntities();
        this.gameScoreboard.resetSidebars();
        ArrayList<Player> winners = new ArrayList<Player>();
        this.cancelTasks();
        for (Player player2 : this.gamePlayerData.getPlayers()) {
            PlayerData playerData = this.playerManager.getPlayerData(player2);
            assert (playerData != null);
            if (playerData.hasGameStared()) {
                Location previousLocation = playerData.getPreviousLocation();
                this.gamePlayerData.heal(player2);
                playerData.restore(player2);
                winners.add(player2);
                this.gamePlayerData.exit(player2, previousLocation);
            }
            this.playerManager.removePlayerData(player2);
        }
        for (Player spectator : this.gamePlayerData.getSpectators()) {
            this.gamePlayerData.leaveSpectate(spectator);
        }
        if (this.gameArenaData.getStatus() == Status.RUNNING) {
            this.bar.clearBar();
        }
        if (!winners.isEmpty() && death) {
            double winningReward = (double)Config.REWARD_CASH / (double)winners.size();
            for (Player winner : winners) {
                if (Config.REWARD_ENABLED) {
                    if (!Config.REWARD_COMMANDS.isEmpty()) {
                        for (String cmd : Config.REWARD_COMMANDS) {
                            if (cmd.equalsIgnoreCase("none")) continue;
                            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd.replace("<player>", winner.getName()));
                        }
                    }
                    if (!Config.REWARD_MESSAGES.isEmpty()) {
                        for (String msg : Config.REWARD_MESSAGES) {
                            if (msg.equalsIgnoreCase("none")) continue;
                            Util.sendMessage((CommandSender)winner, msg.replace("<player>", winner.getName()), new Object[0]);
                        }
                    }
                    if (winningReward > 0.0) {
                        Vault.ECONOMY.depositPlayer((OfflinePlayer)winner, winningReward);
                        Util.sendMessage((CommandSender)winner, this.lang.game_winning_amount.replace("<amount>", "%,.2f"), winningReward);
                    }
                }
                this.plugin.getLeaderboard().addStat(winner, Leaderboard.Stats.WINS);
                this.plugin.getLeaderboard().addStat(winner, Leaderboard.Stats.GAMES);
            }
        }
        this.gameBlockData.clearChests();
        if (death) {
            StringJoiner joiner = new StringJoiner(", ");
            winners.forEach(player -> joiner.add(player.getName()));
            String joinedWinners = joiner.toString();
            String broadcast = this.lang.game_player_won.replace("<arena>", this.gameArenaData.getName()).replace("<winner>", joinedWinners);
            if (Config.SETTINGS_BROADCAST_WIN_MESSAGES) {
                Util.broadcast(broadcast);
            } else {
                this.gamePlayerData.messageAllPlayers(broadcast);
            }
        }
        if (this.gameBlockData.requiresRollback()) {
            if (this.plugin.isEnabled()) {
                new RollbackTask(this);
            } else {
                this.gameBlockData.forceRollback();
            }
        } else {
            this.gameArenaData.setStatus(Status.READY);
        }
        this.gameCommandData.runCommands(GameCommandData.CommandType.STOP, null);
        this.gamePlayerData.postGameReset();
        this.gameScoreboard.postGameReset();
        this.gameItemData.postGameReset();
        this.plugin.getLeaderboard().saveLeaderboard();
        new GameEndEvent(this, winners, death).callEvent();
    }

    void updateAfterDeath(Player player, boolean death) {
        Status status = this.gameArenaData.getStatus();
        if (status == Status.RUNNING || status == Status.FREE_ROAM || status == Status.COUNTDOWN) {
            if (this.isGameOver()) {
                if (!death) {
                    for (Player player1 : this.gamePlayerData.getPlayers()) {
                        if (this.gamePlayerData.getKills().get(player1) < 1) continue;
                        death = true;
                    }
                }
                boolean finalDeath = death;
                if (this.plugin.isEnabled()) {
                    Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                        this.stop(finalDeath);
                        this.gameScoreboard.updateBoards();
                    }, 20L);
                } else {
                    this.stop(finalDeath);
                }
            }
        } else if (status == Status.WAITING) {
            this.gamePlayerData.messageAllActivePlayers(this.lang.game_player_left_game.replace("<arena>", this.gameArenaData.getName()).replace("<player>", player.getName()) + (String)(this.gameArenaData.getMinPlayers() - this.gamePlayerData.getPlayers().size() <= 0 ? "!" : ": " + this.lang.game_waiting_players_to_start.replace("<amount>", String.valueOf(this.gameArenaData.getMinPlayers() - this.gamePlayerData.getPlayers().size()))));
        }
        this.gameBlockData.updateLobbyBlock();
        this.gameScoreboard.updateBoards();
    }

    boolean isGameOver() {
        if (this.gamePlayerData.getPlayers().size() <= 1) {
            return true;
        }
        for (Player player : this.gamePlayerData.getPlayers()) {
            PlayerData playerData = this.playerManager.getPlayerData(player);
            assert (playerData != null);
            GameTeam gameTeam = playerData.getTeam();
            if (gameTeam == null || gameTeam.getPlayers().size() < this.gamePlayerData.getPlayers().size()) continue;
            for (Player player1 : this.gamePlayerData.getPlayers()) {
                if (gameTeam.getPlayers().contains(player1)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean canJoin(Player player) {
        if (this.gamePlayerData.getPlayers().size() >= this.getGameArenaData().getMaxPlayers()) {
            String name = this.gameArenaData.getName();
            Util.sendPrefixedMessage((CommandSender)player, this.lang.game_full.replace("<name>", name), new Object[0]);
            return false;
        }
        int cost = this.getGameArenaData().getCost();
        if (Config.HAS_ECONOMY && cost > 0) {
            if (Vault.ECONOMY.getBalance((OfflinePlayer)player) >= (double)cost) {
                Vault.ECONOMY.withdrawPlayer((OfflinePlayer)player, (double)cost);
                return true;
            }
            Util.sendPrefixedMessage((CommandSender)player, this.lang.command_join_no_money.replace("<cost>", String.valueOf(cost)), new Object[0]);
            return false;
        }
        return true;
    }

    public String toString() {
        return "Game{name='" + this.gameArenaData.getName() + "', bound=" + String.valueOf(this.gameArenaData.getGameRegion()) + "}";
    }
}

