/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.game;

import com.shanebeestudios.hg.api.game.Data;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameRegion;
import com.shanebeestudios.hg.api.status.Status;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;

public class GameArenaData
extends Data {
    private final String name;
    private final GameRegion gameRegion;
    private int timer;
    private int minPlayers;
    private int maxPlayers;
    private int freeRoamTime;
    private int cost;
    private final List<Location> spawns;
    private Location exit;
    private Status status = Status.NOT_READY;
    private int chestRefillTime = 0;
    private int chestRefillRepeat = 0;

    GameArenaData(Game game, String name, GameRegion gameRegion, int timer, int minPlayers, int maxPlayers, int freeRoamTime, int cost) {
        super(game);
        this.name = name;
        this.gameRegion = gameRegion;
        this.timer = timer;
        this.minPlayers = minPlayers;
        this.maxPlayers = maxPlayers;
        this.freeRoamTime = freeRoamTime;
        this.cost = cost;
        this.spawns = new ArrayList<Location>();
    }

    public GameRegion getGameRegion() {
        return this.gameRegion;
    }

    public String getName() {
        return this.name;
    }

    public Component getNameComponent() {
        return Util.getMini(this.name, new Object[0]);
    }

    public boolean isInRegion(Location location) {
        return this.gameRegion.isInRegion(location);
    }

    public Game checkOverlap() {
        for (Game toCheck : HungerGames.getPlugin().getGameManager().getGames()) {
            if (this.game.equals(toCheck) || !toCheck.getGameArenaData().getGameRegion().getBoundingBox().overlaps(this.gameRegion.getBoundingBox())) continue;
            return toCheck;
        }
        return null;
    }

    public int getFreeRoamTime() {
        return this.freeRoamTime;
    }

    public void setFreeRoamTime(int freeRoamTime) {
        this.freeRoamTime = freeRoamTime;
    }

    public int getTimer() {
        return this.timer;
    }

    public void setTimer(int timer) {
        this.timer = timer;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public int getMinPlayers() {
        return this.minPlayers;
    }

    public void setMinPlayers(int minPlayers) {
        this.minPlayers = minPlayers;
    }

    public int getCost() {
        return this.cost;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public List<Location> getSpawns() {
        return this.spawns;
    }

    public void clearSpawns() {
        this.spawns.clear();
    }

    public void addSpawn(Location location) {
        this.spawns.add(location);
    }

    public void setStatus(Status status) {
        this.status = status;
        this.game.getGameBlockData().updateLobbyBlock();
    }

    public Status getStatus() {
        return this.status;
    }

    public Location getExitLocation() {
        return this.exit;
    }

    public void setExitLocation(Location location) {
        this.exit = location;
    }

    public void setChestRefillTime(int time) {
        this.chestRefillTime = time;
    }

    public int getChestRefillTime() {
        return this.chestRefillTime;
    }

    public void setChestRefillRepeat(int chestRefillRepeat) {
        this.chestRefillRepeat = chestRefillRepeat;
    }

    public int getChestRefillRepeat() {
        return this.chestRefillRepeat;
    }
}

