/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.game;

import com.shanebeestudios.hg.api.game.Data;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.util.Util;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;

public class GameBarData
extends Data {
    private BossBar bar;
    private final String title;

    GameBarData(Game game) {
        super(game);
        this.title = this.lang.game_bossbar_title;
    }

    public void createBossBar(int time) {
        int min = time / 60;
        int sec = time % 60;
        String title = this.formatTitle(min, sec);
        this.bar = BossBar.bossBar((Component)Util.getMini(title, new Object[0]), (float)1.0f, (BossBar.Color)BossBar.Color.GREEN, (BossBar.Overlay)BossBar.Overlay.NOTCHED_20);
        for (Player player : this.getGame().getGamePlayerData().getPlayers()) {
            this.bar.addViewer((Audience)player);
        }
        for (Player player : this.getGame().getGamePlayerData().getSpectators()) {
            this.bar.addViewer((Audience)player);
        }
    }

    public void bossBarUpdate(int remaining) {
        if (this.bar == null) {
            return;
        }
        float remain = (float)remaining / (float)this.getGame().getGameArenaData().getTimer();
        int min = remaining / 60;
        int sec = remaining % 60;
        String title = this.formatTitle(min, sec);
        this.bar.name(Util.getMini(title, new Object[0]));
        this.bar.progress(remain);
        if ((double)remain <= 0.5 && (double)remain >= 0.2) {
            this.bar.color(BossBar.Color.YELLOW);
        }
        if ((double)remain < 0.2) {
            this.bar.color(BossBar.Color.RED);
        }
    }

    public void clearBar() {
        if (this.bar != null) {
            this.bar.viewers().forEach(player -> this.bar.removeViewer((Audience)player));
        }
        this.bar = null;
    }

    public void removePlayer(Player player) {
        if (this.bar != null) {
            this.bar.removeViewer((Audience)player);
        }
    }

    public void addPlayer(Player player) {
        if (this.bar != null) {
            this.bar.addViewer((Audience)player);
        }
    }

    private String formatTitle(int min, int sec) {
        return this.title.replace("<min>", String.valueOf(min)).replace("<sec>", String.valueOf(sec));
    }
}

