/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.game;

import com.shanebeestudios.hg.api.data.ItemData;
import com.shanebeestudios.hg.api.data.ItemFrameData;
import com.shanebeestudios.hg.api.game.Data;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameLobbyWall;
import com.shanebeestudios.hg.api.util.BlockUtils;
import com.shanebeestudios.hg.plugin.configs.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.BlockType;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public class GameBlockData
extends Data {
    private final Random random = new Random();
    private final Map<ItemData.ChestType, List<Location>> chests = new HashMap<ItemData.ChestType, List<Location>>();
    private final List<BlockState> blocks = new ArrayList<BlockState>();
    private final List<Block> randomBonusChests = new ArrayList<Block>();
    private final Map<UUID, ItemFrameData> itemFrameData = new HashMap<UUID, ItemFrameData>();
    private final GameLobbyWall gameLobbyWall;

    GameBlockData(Game game) {
        super(game);
        this.gameLobbyWall = new GameLobbyWall(game);
        for (ItemData.ChestType value : ItemData.ChestType.values()) {
            this.chests.put(value, new ArrayList());
        }
    }

    public Location getSignLocation() {
        return this.gameLobbyWall.getSignLocation();
    }

    public boolean setLobbyBlock(Location location) {
        return this.gameLobbyWall.setLobbyBlock(location);
    }

    public void updateLobbyBlock() {
        this.gameLobbyWall.updateLobbyBlock();
    }

    public boolean isLobbyValid() {
        return this.gameLobbyWall.isLobbyValid();
    }

    private void clearChestMaps(ItemData.ChestType ... type) {
        for (ItemData.ChestType chestType : type) {
            this.chests.get((Object)chestType).clear();
        }
    }

    public void markChestForRefill() {
        this.chests.forEach((chestType, locations) -> {
            if (chestType == ItemData.ChestType.REGULAR || chestType == ItemData.ChestType.CHEST_DROP) {
                locations.forEach(location -> {
                    BlockState patt0$temp = location.getBlock().getState();
                    if (patt0$temp instanceof InventoryHolder) {
                        InventoryHolder inventoryHolder = (InventoryHolder)patt0$temp;
                        inventoryHolder.getInventory().clear();
                    }
                });
            }
        });
        this.clearChestMaps(ItemData.ChestType.REGULAR);
        this.clearChestMaps(ItemData.ChestType.BONUS);
    }

    public void clearChests() {
        this.chests.forEach((chestType, locations) -> locations.forEach(location -> {
            BlockState patt0$temp = location.getBlock().getState();
            if (patt0$temp instanceof InventoryHolder) {
                InventoryHolder inventoryHolder = (InventoryHolder)patt0$temp;
                inventoryHolder.getInventory().clear();
            }
        }));
        this.clearChestMaps(ItemData.ChestType.values());
    }

    public void logChest(ItemData.ChestType chestType, Location location) {
        if (this.chests.get((Object)chestType).contains(location)) {
            return;
        }
        this.chests.get((Object)chestType).add(location);
    }

    public void removeChest(Location location) {
        for (ItemData.ChestType value : ItemData.ChestType.values()) {
            this.chests.get((Object)value).remove(location);
        }
    }

    public void removeChest(@NotNull ItemData.ChestType chestType, Location location) {
        this.chests.get((Object)chestType).remove(location);
    }

    public boolean canBeFilled(Location location) {
        for (List<Location> value : this.chests.values()) {
            if (!value.contains(location)) continue;
            return false;
        }
        return true;
    }

    public int logBlocksForRollback() {
        int count = 0;
        for (Location location : this.getGame().getGameArenaData().getGameRegion().getBlocks(null)) {
            Block block = location.getBlock();
            this.blocks.add(block.getState());
            ++count;
            if (!Config.CHESTS_BONUS_RANDOMIZE_ENABLED || !BlockUtils.isBonusBlockReplacement(block)) continue;
            this.randomBonusChests.add(block);
            block.setType(Material.AIR);
        }
        return count;
    }

    public void setupRandomizedBonusChests() {
        if (!Config.CHESTS_BONUS_RANDOMIZE_ENABLED) {
            return;
        }
        Optional first = BlockUtils.getBonusBlockTypes().stream().findFirst();
        if (first.isEmpty()) {
            return;
        }
        BlockData blockData = ((BlockType)first.get()).createBlockData();
        int bonusChestAmount = this.random.nextInt(Config.CHESTS_BONUS_RANDOMIZE_MIN, Config.CHESTS_BONUS_RANDOMIZE_MAX + 1);
        ArrayList<Block> randoms = new ArrayList<Block>(this.randomBonusChests);
        for (int i = 0; i < bonusChestAmount; ++i) {
            if (randoms.isEmpty()) {
                return;
            }
            Collections.shuffle(randoms);
            Block bonusChest = (Block)randoms.getFirst();
            randoms.remove(bonusChest);
            bonusChest.setBlockData(blockData);
        }
    }

    public void forceRollback() {
        Collections.reverse(this.blocks);
        for (BlockState state : this.blocks) {
            state.update(true);
        }
    }

    boolean requiresRollback() {
        return !this.blocks.isEmpty() || !this.itemFrameData.isEmpty();
    }

    public void recordItemFrame(ItemFrame itemFrame) {
        if (this.itemFrameData.containsKey(itemFrame.getUniqueId())) {
            return;
        }
        this.itemFrameData.put(itemFrame.getUniqueId(), new ItemFrameData(itemFrame));
    }

    public Collection<ItemFrameData> getItemFrameData() {
        return this.itemFrameData.values();
    }

    public List<BlockState> getBlocks() {
        Collections.reverse(this.blocks);
        return this.blocks;
    }

    public void resetBlocks() {
        this.blocks.clear();
        this.randomBonusChests.clear();
    }

    public void resetItemFrames() {
        this.itemFrameData.clear();
    }
}

