/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.game;

import com.shanebeestudios.hg.api.game.Data;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameArenaData;
import com.shanebeestudios.hg.api.game.GamePlayerData;
import com.shanebeestudios.hg.api.game.GameRegion;
import com.shanebeestudios.hg.plugin.configs.Config;
import com.shanebeestudios.hg.plugin.tasks.WorldBorderTask;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WorldBorder;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.Nullable;

public class GameBorderData
extends Data {
    private final Random random = new Random();
    private boolean isDefault;
    private Location centerLocation;
    private int finalBorderSize;
    private int borderCountdownStart;
    private int borderCountdownEnd;
    private final GamePlayerData gamePlayerData;
    private final WorldBorder worldBorder;
    private WorldBorderTask worldBorderTask;

    GameBorderData(Game game) {
        this(game, null, Config.WORLD_BORDER_FINAL_SIZE, Config.WORLD_BORDER_COUNTDOWN_START, Config.WORLD_BORDER_COUNTDOWN_END);
        this.isDefault = true;
    }

    GameBorderData(Game game, Location centerLocation, int finalSize, int start, int end) {
        super(game);
        this.gamePlayerData = game.getGamePlayerData();
        this.worldBorder = Bukkit.createWorldBorder();
        this.centerLocation = centerLocation;
        this.finalBorderSize = finalSize;
        this.borderCountdownStart = start;
        this.borderCountdownEnd = end;
        this.isDefault = false;
    }

    public WorldBorder getWorldBorder() {
        return this.worldBorder;
    }

    public void initialize() {
        this.resetBorder();
        this.gamePlayerData.getPlayers().forEach(player -> player.setWorldBorder(this.worldBorder));
        this.worldBorderTask = new WorldBorderTask(this.game);
    }

    public void resetBorder() {
        Location center;
        GameArenaData gameArenaData = this.game.getGameArenaData();
        List<Location> spawns = gameArenaData.getSpawns();
        if (this.centerLocation != null) {
            center = this.centerLocation;
        } else {
            switch (Config.WORLD_BORDER_CENTER) {
                case "first-spawn": {
                    center = spawns.getFirst();
                    break;
                }
                case "random-spawn": {
                    center = spawns.get(this.random.nextInt(spawns.size()));
                    break;
                }
                default: {
                    center = gameArenaData.getGameRegion().getCenter();
                }
            }
        }
        this.worldBorder.setCenter(center);
        GameRegion bound = gameArenaData.getGameRegion();
        BoundingBox boundingBox = bound.getBoundingBox();
        double x = Math.max(center.getX() - boundingBox.getMinX(), boundingBox.getMaxX() - center.getX());
        double z = Math.max(center.getZ() - boundingBox.getMinZ(), boundingBox.getMaxZ() - center.getZ());
        double size = Math.max(x, z);
        this.worldBorder.setSize((size + 5.0) * 2.0);
        if (this.worldBorderTask != null) {
            this.worldBorderTask.stop();
            this.worldBorderTask = null;
        }
    }

    public void startShrinking(int closingIn) {
        this.worldBorder.setSize((double)this.finalBorderSize, (long)closingIn);
    }

    public void setCenterLocation(Location centerLocation) {
        this.centerLocation = centerLocation;
        this.isDefault = false;
    }

    @Nullable
    public Location getCenterLocation() {
        return this.centerLocation;
    }

    public void setFinalBorderSize(int finalBorderSize) {
        this.finalBorderSize = finalBorderSize;
        this.isDefault = false;
    }

    public int getFinalBorderSize() {
        return this.finalBorderSize;
    }

    public int getBorderCountdownStart() {
        return this.borderCountdownStart;
    }

    public void setBorderCountdownStart(int borderCountdownStart) {
        this.borderCountdownStart = borderCountdownStart;
        this.isDefault = false;
    }

    public int getBorderCountdownEnd() {
        return this.borderCountdownEnd;
    }

    public void setBorderCountdownEnd(int borderCountdownEnd) {
        this.borderCountdownEnd = borderCountdownEnd;
        this.isDefault = false;
    }

    public boolean isDefault() {
        return this.isDefault;
    }
}

