/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.game;

import com.shanebeestudios.hg.api.game.Data;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameArenaData;
import com.shanebeestudios.hg.api.util.Constants;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.configs.Config;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.Nullable;

public class GameLobbyWall
extends Data {
    private final GameArenaData gameArenaData;
    private Location signLoc1;
    private Location signLoc2;
    private Location signLoc3;

    protected GameLobbyWall(Game game) {
        super(game);
        this.gameArenaData = game.getGameArenaData();
    }

    public Location getSignLocation() {
        return this.signLoc1;
    }

    protected boolean setLobbyBlock(Location location) {
        GameArenaData gameArenaData = this.game.getGameArenaData();
        try {
            BlockFace face;
            this.signLoc1 = location;
            Sign sign1 = (Sign)location.getBlock().getState();
            PersistentDataContainer pdc = sign1.getPersistentDataContainer();
            pdc.set(Constants.LOBBY_SIGN_KEY, PersistentDataType.STRING, (Object)gameArenaData.getName());
            BlockData sign1Data = sign1.getBlockData();
            if (sign1Data instanceof Directional) {
                Directional directional = (Directional)sign1Data;
                face = Util.getSignFace(directional.getFacing());
            } else if (sign1Data instanceof Rotatable) {
                Rotatable rotatable = (Rotatable)sign1Data;
                face = Util.getSignFace(rotatable.getRotation());
            } else {
                return false;
            }
            Sign sign2 = (Sign)sign1.getBlock().getRelative(face).getState();
            Sign sign3 = (Sign)sign2.getBlock().getRelative(face).getState();
            this.signLoc2 = sign2.getLocation();
            this.signLoc3 = sign3.getLocation();
            this.updateSignLines(List.of(sign1, sign2, sign3));
            sign1.setWaxed(true);
            sign2.setWaxed(true);
            sign3.setWaxed(true);
            sign1.update(true);
            sign2.update(true);
            sign3.update(true);
        }
        catch (Exception e) {
            Util.warning("Failed to setup lobby wall for arena '%s', msg: %s", gameArenaData.getName(), e.getMessage());
            if (Config.SETTINGS_DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    void updateLobbyBlock() {
        if (this.signLoc1 == null || this.signLoc2 == null || this.signLoc3 == null) {
            Util.warning("The lobby wall seems to be missing for '%s'", this.game.getGameArenaData().getName());
            return;
        }
        BlockState blockState = this.signLoc1.getBlock().getState();
        if (blockState instanceof Sign) {
            Sign sign1 = (Sign)blockState;
            blockState = this.signLoc2.getBlock().getState();
            if (blockState instanceof Sign) {
                Sign sign2 = (Sign)blockState;
                blockState = this.signLoc3.getBlock().getState();
                if (blockState instanceof Sign) {
                    Sign sign3 = (Sign)blockState;
                    this.updateSignLines(List.of(sign1, sign2, sign3));
                }
            }
        }
    }

    void updateSignLines(List<Sign> signs) {
        for (int signCount = 0; signCount < 3; ++signCount) {
            List<String> lines = this.lang.lobby_signs_lines.get(signCount);
            Sign sign = signs.get(signCount);
            SignSide side = sign.getSide(Side.FRONT);
            for (int lineCount = 0; lineCount < 4; ++lineCount) {
                String line = this.replacements(lines.get(lineCount));
                if (line == null || line.isEmpty()) continue;
                side.line(lineCount, Util.getMini(line, new Object[0]));
            }
            sign.update(true);
        }
    }

    @Nullable
    private String replacements(String line) {
        if (line.contains("<cost>") && this.gameArenaData.getCost() <= 0) {
            return null;
        }
        return line.replace("<arena>", this.gameArenaData.getName()).replace("<status>", this.gameArenaData.getStatus().getStringName()).replace("<cost>", "" + this.gameArenaData.getCost()).replace("<alive>", "" + this.game.getGamePlayerData().getPlayers().size()).replace("<max_players>", "" + this.gameArenaData.getMaxPlayers());
    }

    boolean isLobbyValid() {
        return this.signLoc1.getBlock().getState() instanceof Sign && this.signLoc2 != null && this.signLoc2.getBlock().getState() instanceof Sign && this.signLoc3 != null && this.signLoc3.getBlock().getState() instanceof Sign;
    }
}

