/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.game;

import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameTeam;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.configs.Language;
import com.shanebeestudios.hg.shaded-api.fastboard.adventure.FastBoard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;

public class GameSidebar {
    private final Game game;
    private final Language lang;
    private final Map<Player, FastBoard> playersFastBoards = new HashMap<Player, FastBoard>();
    private Component title;

    public GameSidebar(Game game) {
        this.game = game;
        this.lang = game.lang;
        this.setTitle(this.lang.scoreboard_sidebar_title);
    }

    public void setBoard(Player player) {
        if (!this.playersFastBoards.containsKey(player)) {
            this.playersFastBoards.put(player, new FastBoard(player));
        }
    }

    public void removePlayer(Player player) {
        FastBoard fastBoard = this.playersFastBoards.get(player);
        if (fastBoard != null) {
            fastBoard.delete();
        }
        this.playersFastBoards.remove(player);
    }

    public void setTitle(String title) {
        this.title = Util.getMini(title, new Object[0]);
    }

    public void updateBoard() {
        String alive = "  " + this.lang.scoreboard_sidebar_players_alive_num.replace("<num>", String.valueOf(this.game.getGamePlayerData().getPlayers().size()));
        String name = this.game.getGameArenaData().getName();
        this.playersFastBoards.forEach((player, board) -> {
            board.updateTitle(this.title);
            ArrayList<Component> lines = new ArrayList<Component>();
            lines.add(Util.getMini(" ", new Object[0]));
            lines.add(Util.getMini(this.lang.scoreboard_sidebar_arena, new Object[0]));
            lines.add(Util.getMini("  <yellow>" + name, new Object[0]));
            lines.add(Util.getMini(" ", new Object[0]));
            lines.add(Util.getMini(this.lang.scoreboard_sidebar_players_alive, new Object[0]));
            lines.add(Util.getMini(alive, new Object[0]));
            lines.add(Util.getMini(" ", new Object[0]));
            GameTeam gameTeam = this.game.getGameScoreboard().getGameTeam((Player)player);
            if (gameTeam != null) {
                lines.add(Util.getMini("Team:", new Object[0]));
                lines.add(Util.getMini(" <grey>Name: <aqua>" + gameTeam.getTeamName(), new Object[0]));
                lines.add(Util.getMini(" <grey>Players: <green>" + gameTeam.getPlayers().size(), new Object[0]));
            }
            board.updateLines(lines);
        });
    }

    public void reset() {
        this.playersFastBoards.forEach((player, fastBoard) -> fastBoard.delete());
        this.playersFastBoards.clear();
    }

    public String toString() {
        return "Board{game=" + String.valueOf(this.game) + "}";
    }
}

