/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.game;

import com.shanebeestudios.hg.api.data.PlayerData;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameScoreboard;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.configs.Config;
import com.shanebeestudios.hg.plugin.configs.Language;
import com.shanebeestudios.hg.plugin.managers.PlayerManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;

public class GameTeam {
    private final Language lang;
    private final PlayerManager playerManager;
    private final GameScoreboard gameScoreboard;
    private final String teamName;
    private final Player leader;
    private final List<Player> players = new ArrayList<Player>();
    private final List<Player> pending = new ArrayList<Player>();
    private final Team bukkitTeam;

    GameTeam(Game game, GameScoreboard gameScoreboard, Player leader, String teamName) {
        this.lang = game.plugin.getLang();
        this.playerManager = game.plugin.getPlayerManager();
        this.gameScoreboard = gameScoreboard;
        this.teamName = teamName;
        this.leader = leader;
        PlayerData playerData = this.playerManager.getPlayerData(leader);
        assert (playerData != null);
        this.players.add(leader);
        playerData.setTeam(this);
        playerData.setPendingTeam(null);
        Team team = gameScoreboard.getScoreboard().getTeam(teamName);
        if (team == null) {
            team = gameScoreboard.getScoreboard().registerNewTeam(teamName);
        }
        this.bukkitTeam = team;
        this.bukkitTeam.addPlayer((OfflinePlayer)leader);
        this.bukkitTeam.setAllowFriendlyFire(Config.TEAM_ALLOW_FRIENDLY_FIRE);
        this.bukkitTeam.setCanSeeFriendlyInvisibles(Config.TEAM_CAN_SEE_INVISIBLES);
        if (Config.SCOREBOARD_HIDE_NAMETAGS && Config.TEAM_SHOW_TEAM_NAMES) {
            this.bukkitTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.FOR_OTHER_TEAMS);
        }
        this.bukkitTeam.prefix(Util.getMini(this.lang.team_prefix.replace("<name>", teamName), new Object[0]));
        this.bukkitTeam.suffix(Util.getMini(this.lang.team_suffix.replace("<name>", teamName), new Object[0]));
    }

    public void invite(Player player) {
        Util.sendMessage((CommandSender)player, this.lang.team_invite_1, new Object[0]);
        Util.sendMessage((CommandSender)player, this.lang.team_invite_2.replace("<inviter>", this.leader.getName()), new Object[0]);
        Util.sendMessage((CommandSender)player, this.lang.team_invite_3, new Object[0]);
        Util.sendMessage((CommandSender)player, this.lang.team_invite_4, new Object[0]);
        this.pending.add(player);
        PlayerData playerData = this.playerManager.getData(player);
        assert (playerData != null);
        playerData.setPendingTeam(this);
    }

    public void acceptInvite(Player player) {
        PlayerData playerData = this.playerManager.getPlayerData(player);
        assert (playerData != null);
        playerData.setPendingTeam(null);
        playerData.setTeam(this);
        this.pending.remove(player);
        this.players.add(player);
        Util.sendMessage((CommandSender)player, this.lang.team_joined, new Object[0]);
        this.bukkitTeam.addPlayer((OfflinePlayer)player);
        this.gameScoreboard.updateBoards();
    }

    public void declineInvite(Player player) {
        PlayerData playerData = this.playerManager.getPlayerData(player);
        assert (playerData != null);
        playerData.setPendingTeam(null);
        this.pending.remove(player);
        Util.sendMessage((CommandSender)this.leader, this.lang.command_team_deny.replace("<player>", player.getName()), new Object[0]);
    }

    public boolean isOnTeam(Player player) {
        return this.players.contains(player);
    }

    public boolean isPending(Player player) {
        return this.pending.contains(player);
    }

    public List<Player> getPlayers() {
        return this.players;
    }

    public List<Player> getPendingPlayers() {
        return this.pending;
    }

    @NotNull
    public Player getLeader() {
        return this.leader;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public void messageMembers(String message) {
        for (Player player : this.players) {
            if (player == null) continue;
            Util.sendMessage((CommandSender)player, message, new Object[0]);
        }
    }

    public void unregister() {
        this.bukkitTeam.unregister();
    }

    public String toString() {
        return "GameTeam{, teamName='" + this.teamName + "', leader=" + String.valueOf(this.leader) + ", players=" + String.valueOf(this.players) + ", pending=" + String.valueOf(this.pending) + "}";
    }
}

