/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.gui;

import com.shanebeestudios.hg.api.data.KitEntry;
import com.shanebeestudios.hg.api.gui.KitsGUI;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.configs.Language;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;

public class KitGUI
implements InventoryHolder {
    private final Language lang = HungerGames.getPlugin().getLang();
    private final KitsGUI kitsGUI;
    private final KitEntry kitEntry;
    private final Player player;
    private final Inventory inventory;

    public KitGUI(KitsGUI kitsGUI, Player player, KitEntry kitEntry) {
        this.kitsGUI = kitsGUI;
        this.kitEntry = kitEntry;
        this.player = player;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (Component)Util.getMini(this.lang.kits_kit_gui_title.replace("<name>", kitEntry.getName()), new Object[0]));
        ItemStack divider = ItemType.BLACK_STAINED_GLASS_PANE.createItemStack();
        if (Util.RUNNING_1_21_5) {
            divider.setData(DataComponentTypes.TOOLTIP_DISPLAY, (DataComponentBuilder)TooltipDisplay.tooltipDisplay().hideTooltip(true));
        } else {
            divider.setData(DataComponentTypes.CUSTOM_NAME, (Object)Component.text((String)" "));
        }
        for (int i = 9; i < 18; ++i) {
            this.inventory.setItem(i, divider);
        }
        ItemStack exit = ItemType.RED_CONCRETE.createItemStack();
        exit.setData(DataComponentTypes.ITEM_NAME, (Object)Util.getMini(this.lang.kits_kit_gui_exit, new Object[0]));
        this.inventory.setItem(8, exit);
        ItemStack apply = ItemType.GREEN_CONCRETE.createItemStack();
        apply.setData(DataComponentTypes.ITEM_NAME, (Object)Util.getMini(this.lang.kits_kit_gui_apply, new Object[0]));
        this.inventory.setItem(7, apply);
        ItemStack helmet = kitEntry.getHelmet();
        if (helmet == null) {
            helmet = ItemType.BARRIER.createItemStack();
            helmet.setData(DataComponentTypes.ITEM_NAME, (Object)Util.getMini(this.lang.kits_kit_gui_no_helmet, new Object[0]));
        }
        this.inventory.setItem(0, helmet);
        ItemStack chestplate = kitEntry.getChestplate();
        if (chestplate == null) {
            chestplate = ItemType.BARRIER.createItemStack();
            chestplate.setData(DataComponentTypes.ITEM_NAME, (Object)Util.getMini(this.lang.kits_kit_gui_no_chestplate, new Object[0]));
        }
        this.inventory.setItem(1, chestplate);
        ItemStack leggings = kitEntry.getLeggings();
        if (leggings == null) {
            leggings = ItemType.BARRIER.createItemStack();
            leggings.setData(DataComponentTypes.ITEM_NAME, (Object)Util.getMini(this.lang.kits_kit_gui_no_leggings, new Object[0]));
        }
        this.inventory.setItem(2, leggings);
        ItemStack boots = kitEntry.getBoots();
        if (boots == null) {
            boots = ItemType.BARRIER.createItemStack();
            boots.setData(DataComponentTypes.ITEM_NAME, (Object)Util.getMini(this.lang.kits_kit_gui_no_boots, new Object[0]));
        }
        this.inventory.setItem(3, boots);
        ItemStack potion = ItemType.POTION.createItemStack();
        potion.setData(DataComponentTypes.CUSTOM_NAME, (Object)Util.getMini(this.lang.kits_kit_gui_potion_effects, new Object[0]));
        if (Util.RUNNING_1_21_5) {
            potion.setData(DataComponentTypes.TOOLTIP_DISPLAY, (DataComponentBuilder)TooltipDisplay.tooltipDisplay().hideTooltip(true));
        } else {
            potion.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
        }
        List<PotionEffect> potionEffects = kitEntry.getPotionEffects();
        ArrayList<Component> lore = new ArrayList<Component>();
        if (potionEffects.isEmpty()) {
            lore.add(Util.getMini(this.lang.kits_kit_gui_potion_effect_none, new Object[0]));
        } else {
            potionEffects.forEach(effect -> lore.add(Util.getMini(this.lang.kits_kit_gui_potion_effect_lore.replace("<type>", effect.getType().translationKey()), new Object[0])));
        }
        potion.setData(DataComponentTypes.LORE, (Object)ItemLore.lore(lore));
        this.inventory.setItem(5, potion);
        int slot = 18;
        for (ItemStack item : kitEntry.getInventoryContents()) {
            this.inventory.setItem(slot, item);
            ++slot;
        }
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    public void click(int slot) {
        if (slot == 7) {
            this.kitsGUI.getKitData().setKit(this.player, this.kitEntry);
            this.player.closeInventory();
        } else if (slot == 8) {
            this.kitsGUI.open();
        }
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }
}

