/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.parsers;

import com.shanebeestudios.hg.api.registry.Registries;
import com.shanebeestudios.hg.api.util.NBTApi;
import com.shanebeestudios.hg.api.util.Util;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.DyedItemColor;
import io.papermc.paper.datacomponent.item.ItemEnchantments;
import io.papermc.paper.datacomponent.item.PotionContents;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bukkit.Color;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.Nullable;

public class ItemParser {
    @Nullable
    public static ItemStack parseItem(@Nullable ConfigurationSection config) {
        ItemEnchantments.Builder builder;
        if (config == null) {
            return null;
        }
        String stringId = config.getString("id");
        if (stringId == null) {
            return null;
        }
        NamespacedKey key = NamespacedKey.fromString((String)stringId.toLowerCase(Locale.ROOT));
        if (key == null) {
            return null;
        }
        ItemType itemType = (ItemType)Registries.ITEM_TYPE_REGISTRY.get(key);
        if (itemType == null) {
            return null;
        }
        int count = 1;
        if (config.contains("count")) {
            count = config.getInt("count");
        }
        ItemStack itemStack = itemType.createItemStack(count);
        if (config.contains("max_stack_size")) {
            int maxStackSize = config.getInt("max_stack_size");
            itemStack.setData(DataComponentTypes.MAX_STACK_SIZE, (Object)Math.clamp((long)maxStackSize, 1, 99));
        }
        if (config.contains("custom_name")) {
            String name = config.getString("custom_name");
            itemStack.setData(DataComponentTypes.CUSTOM_NAME, (Object)Util.getMini(name, new Object[0]));
        } else if (config.contains("item_name")) {
            String name = config.getString("item_name");
            itemStack.setData(DataComponentTypes.ITEM_NAME, (Object)Util.getMini(name, new Object[0]));
        }
        if (config.contains("item_model")) {
            String model = config.getString("item_model");
            assert (model != null);
            NamespacedKey modelKey = NamespacedKey.fromString((String)model);
            if (modelKey == null) {
                Util.warning("Invalid item model: " + model, new Object[0]);
            } else {
                itemStack.setData(DataComponentTypes.ITEM_MODEL, (Object)modelKey);
            }
        }
        if (config.contains("lore")) {
            List lore = config.getStringList("lore");
            ArrayList loreComponents = new ArrayList();
            lore.forEach(l -> loreComponents.add(Util.getMini(l, new Object[0])));
            itemStack.lore(loreComponents);
        }
        if (config.isConfigurationSection("enchantments")) {
            ConfigurationSection enchantments = config.getConfigurationSection("enchantments");
            assert (enchantments != null);
            builder = ItemEnchantments.itemEnchantments();
            for (String eKey : enchantments.getKeys(false)) {
                NamespacedKey namespacedKey = NamespacedKey.fromString((String)eKey);
                if (namespacedKey != null) {
                    Enchantment enchantment = (Enchantment)Registries.ENCHANTMENT_REGISTRY.get(namespacedKey);
                    if (enchantment != null) {
                        int level = enchantments.getInt(eKey);
                        builder.add(enchantment, level);
                        continue;
                    }
                    Util.warning("Invalid enchantment key '%s'", namespacedKey.toString());
                    continue;
                }
                Util.warning("Invalid enchantment key '%s'", eKey);
            }
            itemStack.setData(DataComponentTypes.ENCHANTMENTS, (Object)((ItemEnchantments)builder.build()));
        }
        if (config.contains("max_damage")) {
            int maxDamage = config.getInt("max_damage");
            itemStack.setData(DataComponentTypes.MAX_DAMAGE, (Object)maxDamage);
        }
        if (config.contains("damage")) {
            int damage = config.getInt("damage");
            itemStack.setData(DataComponentTypes.DAMAGE, (Object)damage);
        }
        if (config.contains("potion")) {
            Object potionType;
            String string = config.getString("potion");
            assert (string != null);
            NamespacedKey namespacedKey = NamespacedKey.fromString((String)string);
            if (namespacedKey != null && (potionType = (PotionType)Registries.POTION_TYPE_REGISTRY.get(namespacedKey)) != null) {
                PotionContents.Builder builder2 = PotionContents.potionContents();
                builder2.potion((PotionType)potionType);
                itemStack.setData(DataComponentTypes.POTION_CONTENTS, (Object)((PotionContents)builder2.build()));
            }
        }
        if (config.isConfigurationSection("potion_effects")) {
            ConfigurationSection potionEffectsSection = config.getConfigurationSection("potion_effects");
            assert (potionEffectsSection != null);
            builder = PotionContents.potionContents();
            for (String peKey : potionEffectsSection.getKeys(false)) {
                PotionEffect potionEffect = ItemParser.parsePotionEffect(peKey, potionEffectsSection);
                if (potionEffect == null) continue;
                builder.addCustomEffect(potionEffect);
            }
            if (config.isInt("custom_color")) {
                int color = config.getInt("custom_color");
                builder.customColor(Color.fromRGB((int)color));
            }
            itemStack.setData(DataComponentTypes.POTION_CONTENTS, (Object)((PotionContents)builder.build()));
        }
        if (config.contains("dyed_color")) {
            int color = config.getInt("dyed_color");
            itemStack.setData(DataComponentTypes.DYED_COLOR, (DataComponentBuilder)DyedItemColor.dyedItemColor().color(Color.fromRGB((int)color)));
            if (!Util.RUNNING_1_21_5) {
                itemStack.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            }
        }
        if (Util.RUNNING_1_21_5 && config.isList("hidden_components")) {
            TooltipDisplay.Builder builder3 = TooltipDisplay.tooltipDisplay();
            for (String compKey : config.getStringList("hidden_components")) {
                NamespacedKey namespacedKey = NamespacedKey.fromString((String)compKey);
                if (namespacedKey == null) {
                    Util.warning("Invalid component key: " + compKey, new Object[0]);
                    continue;
                }
                DataComponentType type = (DataComponentType)Registries.DATA_COMPONENT_TYPE_REGISTRY.get(namespacedKey);
                if (type == null) {
                    Util.warning("Invalid component key: " + compKey, new Object[0]);
                    continue;
                }
                builder3.addHiddenComponents(new DataComponentType[]{type});
            }
            itemStack.setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)((TooltipDisplay)builder3.build()));
        }
        if (config.contains("nbt")) {
            String nbtString = config.getString("nbt");
            NBTApi.applyNBTToItem(itemStack, nbtString);
        }
        return itemStack;
    }

    public static PotionEffect parsePotionEffect(String key, ConfigurationSection potionEffectsSection) {
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)key);
        if (namespacedKey != null) {
            PotionEffectType potionEffectType = (PotionEffectType)Registries.POTION_EFFECT_TYPE_REGISTRY.get(namespacedKey);
            ConfigurationSection potionEffectSection = potionEffectsSection.getConfigurationSection(key);
            assert (potionEffectSection != null);
            if (potionEffectType != null) {
                int duration = potionEffectSection.getInt("duration", 300);
                int amplifier = potionEffectSection.getInt("amplifier", 0);
                boolean ambient = potionEffectSection.getBoolean("ambient", false);
                boolean show_icon = potionEffectSection.getBoolean("show_icon", true);
                boolean show_particles = potionEffectSection.getBoolean("show_particles", true);
                return new PotionEffect(potionEffectType, duration, amplifier, ambient, show_particles, show_icon);
            }
        }
        return null;
    }
}

