/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.parsers;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.Nullable;

public class LocationParser {
    public static String blockLocToString(Location location) {
        return location.getWorld().getName() + ":" + location.getBlockX() + ":" + location.getBlockY() + ":" + location.getBlockZ();
    }

    public static String locToString(Location location) {
        float yaw = (float)Math.floor(location.getYaw());
        float pitch = (float)Math.floor(location.getPitch());
        return location.getWorld().getName() + ":" + location.getX() + ":" + location.getY() + ":" + location.getZ() + ":" + yaw + ":" + pitch;
    }

    public static Location getBlockLocFromString(String stringLocation) {
        String[] split = stringLocation.split(":");
        return new Location(Bukkit.getServer().getWorld(split[0]), (double)Integer.parseInt(split[1]), (double)Integer.parseInt(split[2]), (double)Integer.parseInt(split[3]));
    }

    @Nullable
    public static Location getLocFromString(String stringLocation) {
        String[] split = stringLocation.split(":");
        if (split.length < 4) {
            return null;
        }
        World world = Bukkit.getWorld((String)split[0]);
        double x = Double.parseDouble(split[1]);
        double y = Double.parseDouble(split[2]);
        double z = Double.parseDouble(split[3]);
        float yaw = 0.0f;
        float pitch = 0.0f;
        if (split.length >= 5) {
            yaw = Float.parseFloat(split[4]);
        }
        if (split.length == 6) {
            pitch = Float.parseFloat(split[5]);
        }
        return new Location(world, x, y, z, yaw, pitch);
    }
}

