/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.util;

import com.shanebeestudios.hg.api.util.Util;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Locale;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public class PotionEffectUtils {
    private static final Registry<PotionEffectType> POTION_EFFECT_TYPES = RegistryAccess.registryAccess().getRegistry(RegistryKey.MOB_EFFECT);

    public static PotionEffectType getByKey(String key) {
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)key.toLowerCase(Locale.ROOT));
        if (namespacedKey != null) {
            return (PotionEffectType)POTION_EFFECT_TYPES.get(namespacedKey);
        }
        return null;
    }

    @Nullable
    public static PotionEffect getPotionEffect(String data) {
        String[] potionData = data.split(":");
        if (potionData.length == 3) {
            PotionEffectType type = PotionEffectUtils.getByKey(potionData[0]);
            if (type == null) {
                PotionEffectUtils.potionWarning("Potion effect type not found: &c" + potionData[0].toUpperCase() + " &ein: &b" + data);
                return null;
            }
            if (!Util.isInt(potionData[1])) {
                PotionEffectUtils.potionWarning("Potion duration incorrect format: &c" + potionData[1] + " &ein: &b" + data);
                return null;
            }
            if (!Util.isInt(potionData[2])) {
                PotionEffectUtils.potionWarning("Potion amplifier incorrect format: &c" + potionData[2] + " &ein: &b" + data);
                return null;
            }
            int duration = Integer.parseInt(potionData[1]);
            int amplifier = Integer.parseInt(potionData[2]);
            return new PotionEffect(type, duration, amplifier);
        }
        PotionEffectUtils.potionWarning("Improper setup of potion: &c" + data);
        return null;
    }

    private static void potionWarning(@Nullable String warning) {
        if (warning != null) {
            Util.warning(warning, new Object[0]);
        }
        Util.warning("&r  - Check your configs", new Object[0]);
        Util.warning("&r  - Proper example:", new Object[0]);
        Util.warning("      &bpotion:POTION_EFFECT_TYPE:DURATION_IN_TICKS:AMPLIFIER", new Object[0]);
        Util.warning("      &bpotion:instant_health:200:1", new Object[0]);
    }
}

