/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.util;

import com.shanebeestudios.hg.api.util.Util;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Locale;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.Nullable;

public class PotionTypeUtils {
    private static final Registry<PotionType> POTION_TYPES = RegistryAccess.registryAccess().getRegistry(RegistryKey.POTION);

    @Nullable
    public static PotionType getByKey(String key) {
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)key.toLowerCase(Locale.ROOT));
        if (namespacedKey != null) {
            return (PotionType)POTION_TYPES.get(namespacedKey);
        }
        return null;
    }

    public static PotionType getByBukkit(String bukkit) {
        return PotionType.valueOf((String)bukkit.toUpperCase());
    }

    @Nullable
    public static PotionType getPotionData(String data) {
        String[] potionData = data.split(":");
        if (potionData.length == 1) {
            PotionType potionType = PotionTypeUtils.getByKey(potionData[0]);
            if (potionType == null) {
                PotionTypeUtils.potionTypeWarning("Potion base type not found: &c" + potionData[0].toUpperCase(Locale.ROOT) + " &ein: &b" + data);
                return null;
            }
            return potionType;
        }
        PotionTypeUtils.potionTypeWarning("Improper setup of potion-data: &c" + data);
        return null;
    }

    private static void potionTypeWarning(@Nullable String warning) {
        if (warning != null) {
            Util.warning(warning, new Object[0]);
        }
        Util.warning("&r  - Check your configs", new Object[0]);
        Util.warning("&r  - Proper examples:", new Object[0]);
        Util.warning("      &bpotion-base:turtle_master", new Object[0]);
        Util.warning("      &bpotion-base:long_turtle_master", new Object[0]);
        Util.warning("      &bpotion-base:strong_turtle_master", new Object[0]);
    }
}

