/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.util;

import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.configs.Config;
import com.shanebeestudios.hg.plugin.configs.Language;
import com.shanebeestudios.hg.shaded-api.commandapi.arguments.CustomArgument;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static final boolean RUNNING_1_21_5 = Util.isRunningMinecraft(1, 21, 5);
    public static final boolean IS_RUNNING_FOLIA = Util.classExists("io.papermc.paper.threadedregions.FoliaWatchdogThread");
    private static final Pattern HEX_PATTERN = Pattern.compile("<#([A-Fa-f0-9]){6}>");
    private static final CommandSender CONSOLE = Bukkit.getConsoleSender();
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private static String PREFIX;

    private static String getPrefix() {
        if (PREFIX == null) {
            Language lang = HungerGames.getPlugin().getLang();
            if (lang != null) {
                PREFIX = lang.prefix;
            } else {
                return "<grey>[<aqua>Hunger<dark_aqua>Games<grey>]";
            }
        }
        return PREFIX;
    }

    public static void log(String format, Object ... args) {
        String s = String.format(format, args);
        Component mini = Util.getMini("<grey>[<aqua>Hunger<dark_aqua>Games<grey>] " + s, new Object[0]);
        CONSOLE.sendMessage(mini);
    }

    public static void sendPrefixedMessage(@Nullable CommandSender sender, @NotNull String format, Object ... args) {
        if (sender == null) {
            return;
        }
        String s = String.format(format, args);
        Component mini = Util.getMini(Util.getPrefix() + " " + s, new Object[0]);
        sender.sendMessage(mini);
    }

    public static void sendMessage(CommandSender sender, String format, Object ... args) {
        if (format.isEmpty()) {
            return;
        }
        String s = String.format(format, args);
        Component mini = Util.getMini(s, new Object[0]);
        sender.sendMessage(mini);
    }

    public static void warning(String format, Object ... objects) {
        if (!format.isEmpty()) {
            Util.sendMessage(CONSOLE, "<grey>[<yellow><bold>HungerGames<grey>] <yellow>WARNING: " + format, objects);
        }
    }

    public static void debug(String debug) {
        if (Config.SETTINGS_DEBUG) {
            Util.log(debug, new Object[0]);
        }
    }

    public static void debug(@NotNull Exception exception) {
        if (Config.SETTINGS_DEBUG) {
            Util.log("<red>ERROR: (please report to dev):", new Object[0]);
            CONSOLE.sendMessage(Util.getMini("<yellow>%s", exception.getMessage()));
            for (StackTraceElement element : exception.getStackTrace()) {
                CONSOLE.sendMessage(Util.getMini("  <grey>at <red>%s", element));
            }
        }
    }

    public static void broadcast(String s) {
        if (!s.isEmpty()) {
            Bukkit.broadcast((Component)Util.getMini(Util.getPrefix() + " " + s, new Object[0]));
        }
    }

    @Deprecated(forRemoval=true)
    public static String getColString(String string) {
        if (Util.isRunningMinecraft(1, 16)) {
            Matcher matcher = HEX_PATTERN.matcher((CharSequence)string);
            while (matcher.find()) {
                ChatColor hexColor = ChatColor.of((String)matcher.group().substring(1, matcher.group().length() - 1));
                String before = ((String)string).substring(0, matcher.start());
                String after = ((String)string).substring(matcher.end());
                string = before + String.valueOf(hexColor) + after;
                matcher = HEX_PATTERN.matcher((CharSequence)string);
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static Component getMini(String format, Object ... objects) {
        return MINI_MESSAGE.deserialize((Object)String.format(format, objects));
    }

    public static void throwCustomArgException(String message) throws CustomArgument.CustomArgumentException {
        throw CustomArgument.CustomArgumentException.fromAdventureComponent((ComponentLike)Util.getMini(Util.getPrefix() + " " + message, new Object[0]));
    }

    @NotNull
    public static String unMini(Component component) {
        if (component == null) {
            return "";
        }
        return (String)MINI_MESSAGE.serialize(component);
    }

    public static boolean isInt(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static BlockFace getSignFace(BlockFace face) {
        return switch (face) {
            case BlockFace.WEST -> BlockFace.SOUTH;
            case BlockFace.SOUTH -> BlockFace.EAST;
            case BlockFace.EAST -> BlockFace.NORTH;
            default -> BlockFace.WEST;
        };
    }

    public static void clearInv(Player player) {
        player.getInventory().clear();
        player.getInventory().setHelmet(null);
        player.getInventory().setChestplate(null);
        player.getInventory().setLeggings(null);
        player.getInventory().setBoots(null);
        player.updateInventory();
    }

    @NotNull
    public static NamespacedKey getPluginKey(String key) {
        return NamespacedKey.fromString((String)("hungergames:" + key));
    }

    public static boolean isRunningMinecraft(int major, int minor) {
        return Util.isRunningMinecraft(major, minor, 0);
    }

    public static boolean isRunningMinecraft(int major, int minor, int revision) {
        int rev;
        String[] version = Bukkit.getServer().getBukkitVersion().split("-")[0].split("\\.");
        int maj = Integer.parseInt(version[0]);
        int min = Integer.parseInt(version[1]);
        try {
            rev = Integer.parseInt(version[2]);
        }
        catch (Exception ignore) {
            rev = 0;
        }
        return maj > major || min > minor || min == minor && rev >= revision;
    }

    public static boolean methodExists(Class<?> c, String methodName, Class<?> ... parameterTypes) {
        try {
            c.getDeclaredMethod(methodName, parameterTypes);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }

    public static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

