/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.commands;

import com.shanebeestudios.hg.api.data.KitData;
import com.shanebeestudios.hg.api.data.KitEntry;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.status.Status;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.commands.SubCommand;
import com.shanebeestudios.hg.plugin.permission.Permissions;
import com.shanebeestudios.hg.shaded-api.commandapi.AbstractArgumentTree;
import com.shanebeestudios.hg.shaded-api.commandapi.arguments.Argument;
import com.shanebeestudios.hg.shaded-api.commandapi.arguments.ArgumentSuggestions;
import com.shanebeestudios.hg.shaded-api.commandapi.arguments.LiteralArgument;
import com.shanebeestudios.hg.shaded-api.commandapi.arguments.StringArgument;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class KitCommand
extends SubCommand {
    public KitCommand(HungerGames plugin) {
        super(plugin);
    }

    @Override
    protected Argument<?> register() {
        return (Argument)((Argument)LiteralArgument.literal("kit").withPermission(Permissions.COMMAND_KIT.permission())).then((AbstractArgumentTree)((Argument)new StringArgument("kit_name").includeSuggestions(ArgumentSuggestions.stringCollectionAsync(info -> {
            Player player = (Player)info.sender();
            Game game = this.plugin.getPlayerManager().getGame(player);
            if (game == null) {
                return CompletableFuture.completedFuture(null);
            }
            Status status = game.getGameArenaData().getStatus();
            if (status != Status.WAITING && status != Status.COUNTDOWN) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.supplyAsync(() -> game.getGameItemData().getKitData().getKitNameList(player));
        }))).executesPlayer(info -> {
            Player player = (Player)info.sender();
            Game game = this.plugin.getPlayerManager().getGame(player);
            if (game == null) {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_base_not_in_valid_game, new Object[0]);
                return;
            }
            String kitName = info.args().getByClass("kit_name", String.class);
            if (kitName == null) {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_kit_invalid_name, new Object[0]);
                return;
            }
            Status status = game.getGameArenaData().getStatus();
            if (status != Status.WAITING && status != Status.COUNTDOWN) {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_kit_game_running, new Object[0]);
                return;
            }
            KitData kitData = game.getGameItemData().getKitData();
            KitEntry kitEntry = kitData.getKitEntry(kitName);
            if (kitEntry == null) {
                Util.sendMessage((CommandSender)player, "<red>" + kitName + this.lang.kits_doesnt_exist, new Object[0]);
                Util.sendMessage((CommandSender)player, "Available Kits:" + String.valueOf(kitData.getKitNameList(player)), new Object[0]);
                return;
            }
            if (!kitData.hasKitPermission(player, kitName)) {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_kit_no_permission, new Object[0]);
                return;
            }
            kitData.setKit(player, kitEntry);
        }));
    }
}

