/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.commands;

import com.shanebeestudios.hg.api.command.CustomArg;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.commands.SubCommand;
import com.shanebeestudios.hg.plugin.permission.Permissions;
import com.shanebeestudios.hg.shaded-api.commandapi.AbstractArgumentTree;
import com.shanebeestudios.hg.shaded-api.commandapi.arguments.Argument;
import com.shanebeestudios.hg.shaded-api.commandapi.arguments.LiteralArgument;
import com.shanebeestudios.hg.shaded-api.commandapi.executors.ExecutorType;
import java.util.List;
import java.util.StringJoiner;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ListCommand
extends SubCommand {
    public ListCommand(HungerGames plugin) {
        super(plugin);
    }

    @Override
    protected Argument<?> register() {
        return (Argument)((Argument)((Argument)LiteralArgument.literal("list").withPermission(Permissions.COMMAND_LIST.permission())).executesPlayer(info -> {
            Player player = (Player)info.sender();
            Game game = this.playerManager.getGame(player);
            if (game == null) {
                Util.sendPrefixedMessage((CommandSender)player, this.lang.command_base_not_in_valid_game, new Object[0]);
                return;
            }
            List<Player> players = game.getGamePlayerData().getPlayers();
            StringJoiner joiner = new StringJoiner(this.lang.command_list_players_delimiter);
            if (players.isEmpty()) {
                joiner.add("<red>none");
            } else {
                players.forEach(p -> joiner.add(p.getName()));
            }
            Util.sendPrefixedMessage((CommandSender)player, this.lang.command_list_players.replace("<arena>", game.getGameArenaData().getName()).replace("<players>", joiner.toString()), new Object[0]);
        })).then((AbstractArgumentTree)((Argument)CustomArg.GAME.get("game").withPermission(Permissions.COMMAND_LIST_GAME.permission())).executes(info -> {
            Game game = info.args().getByClass("game", Game.class);
            assert (game != null);
            List<Player> players = game.getGamePlayerData().getPlayers();
            StringJoiner joiner = new StringJoiner(this.lang.command_list_players_delimiter);
            if (players.isEmpty()) {
                joiner.add("<red>none");
            } else {
                players.forEach(p -> joiner.add(p.getName()));
            }
            Util.sendPrefixedMessage((CommandSender)info.sender(), this.lang.command_list_players.replace("<arena>", game.getGameArenaData().getName()).replace("<players>", joiner.toString()), new Object[0]);
        }, new ExecutorType[0]));
    }
}

