/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.commands;

import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.commands.SubCommand;
import com.shanebeestudios.hg.plugin.permission.Permissions;
import com.shanebeestudios.hg.shaded-api.commandapi.AbstractArgumentTree;
import com.shanebeestudios.hg.shaded-api.commandapi.arguments.Argument;
import com.shanebeestudios.hg.shaded-api.commandapi.arguments.LiteralArgument;
import com.shanebeestudios.hg.shaded-api.commandapi.executors.ExecutorType;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ReloadCommand
extends SubCommand {
    public ReloadCommand(HungerGames plugin) {
        super(plugin);
    }

    @Override
    protected Argument<?> register() {
        return (Argument)((Argument)((Argument)((Argument)LiteralArgument.literal("reload").withPermission(Permissions.COMMAND_RELOAD.permission())).then((AbstractArgumentTree)LiteralArgument.literal("confirm").executes(info -> this.reload((CommandSender)info.sender()), new ExecutorType[0]))).then((AbstractArgumentTree)LiteralArgument.literal("cancel").executes(info -> Util.sendPrefixedMessage((CommandSender)info.sender(), "<red>Reload cancelled", new Object[0]), new ExecutorType[0]))).executes(info -> {
            CommandSender sender = (CommandSender)info.sender();
            if (this.gamesNotRunning(sender)) {
                this.reload(sender);
            }
        }, new ExecutorType[0]);
    }

    private void reload(CommandSender sender) {
        long start = System.currentTimeMillis();
        Util.sendPrefixedMessage(sender, "<gold>Reloading plugin... observe console for errors!", new Object[0]);
        this.plugin.reloadPlugin();
        Util.sendPrefixedMessage(sender, "<grey>Reloaded <green>successfully <grey>in <aqua>" + (System.currentTimeMillis() - start) + "<grey> milliseconds", new Object[0]);
    }

    public boolean gamesNotRunning(CommandSender sender) {
        int running = this.gameManager.gamesRunning();
        if (running > 0) {
            Util.sendPrefixedMessage(sender, "<gold>There are still <aqua>" + running + "<gold> games running.", new Object[0]);
            Util.sendMessage(sender, "<gold>Do you wish to stop all games and reload?", new Object[0]);
            if (sender instanceof Player) {
                Component yes = this.clickableCommand("<green>YES", "/hg reload confirm", lines -> {
                    lines.add("<grey>Click <green>YES");
                    lines.add("<grey>to stop all games");
                    lines.add("<grey>and reload");
                });
                Component space = Util.getMini(" <grey>or ", new Object[0]);
                Component no = this.clickableCommand("<red>NO", "/hg reload cancel", lines -> {
                    lines.add("<grey>Click <red>NO");
                    lines.add("<grey>to cancel reload");
                });
                TextComponent msg = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(yes)).append(space)).append(no)).build();
                sender.sendMessage((Component)msg);
            } else {
                Util.log("<gold>Type <aqua>hg reload confirm <gold>to force reload.", new Object[0]);
            }
            return false;
        }
        return true;
    }

    private Component clickableCommand(@NotNull String message, @NotNull String command, Consumer<List<String>> hover) {
        Component msg = Util.getMini(message, new Object[0]);
        msg = msg.clickEvent(ClickEvent.runCommand((String)command));
        if (hover != null) {
            ArrayList hovers = new ArrayList();
            hover.accept(hovers);
            StringJoiner joiner = new StringJoiner("<newline>");
            hovers.forEach(joiner::add);
            Component mini = Util.getMini(joiner.toString(), new Object[0]);
            msg = msg.hoverEvent((HoverEventSource)HoverEvent.showText((Component)mini));
        }
        return msg;
    }
}

