/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.plugin.commands;

import com.shanebeestudios.hg.api.command.CustomArg;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameArenaData;
import com.shanebeestudios.hg.api.status.Status;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.commands.SubCommand;
import com.shanebeestudios.hg.plugin.permission.Permissions;
import com.shanebeestudios.hg.shaded-api.commandapi.AbstractArgumentTree;
import com.shanebeestudios.hg.shaded-api.commandapi.arguments.Argument;
import com.shanebeestudios.hg.shaded-api.commandapi.arguments.LiteralArgument;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SpectateCommand
extends SubCommand {
    public SpectateCommand(HungerGames plugin) {
        super(plugin);
    }

    @Override
    protected Argument<?> register() {
        return (Argument)((Argument)LiteralArgument.literal("spectate").withPermission(Permissions.COMMAND_SPECTATE.permission())).then((AbstractArgumentTree)CustomArg.GAME.get("game").executesPlayer(info -> {
            Player player = (Player)info.sender();
            if (this.playerManager.hasPlayerData(player) || this.playerManager.hasSpectatorData(player)) {
                Util.sendMessage((CommandSender)player, this.lang.command_join_already_in_game, new Object[0]);
            } else {
                Game game = info.args().getByClass("game", Game.class);
                assert (game != null);
                GameArenaData arenaData = game.getGameArenaData();
                Status status = arenaData.getStatus();
                if (status == Status.RUNNING || status == Status.FREE_ROAM) {
                    game.getGamePlayerData().spectate(player);
                } else {
                    Util.sendPrefixedMessage((CommandSender)player, this.lang.listener_not_running, new Object[0]);
                    Util.sendMessage((CommandSender)player, this.lang.command_base_status.replace("<arena>", arenaData.getName()).replace("<status>", status.getStringName()), new Object[0]);
                }
            }
        }));
    }
}

